/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.connection.lettuce.DefaultLettuceClientConfiguration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface LettuceClientConfiguration {
    public boolean isUseSsl();

    public boolean isVerifyPeer();

    public boolean isStartTls();

    public Optional<ClientResources> getClientResources();

    public Optional<ClientOptions> getClientOptions();

    public Duration getCommandTimeout();

    public Duration getShutdownTimeout();

    public static LettuceClientConfigurationBuilder builder() {
        return new LettuceClientConfigurationBuilder();
    }

    public static LettuceClientConfiguration defaultConfiguration() {
        return LettuceClientConfiguration.builder().build();
    }

    public static class LettuceSslClientConfigurationBuilder {
        private LettuceClientConfigurationBuilder delegate;

        LettuceSslClientConfigurationBuilder(LettuceClientConfigurationBuilder delegate) {
            Assert.notNull((Object)delegate, (String)"Delegate client configuration builder must not be null!");
            this.delegate = delegate;
        }

        LettuceSslClientConfigurationBuilder disablePeerVerification() {
            this.delegate.verifyPeer = false;
            return this;
        }

        LettuceSslClientConfigurationBuilder startTls() {
            this.delegate.startTls = true;
            return this;
        }

        LettuceClientConfigurationBuilder and() {
            return this.delegate;
        }

        LettuceClientConfiguration build() {
            return this.delegate.build();
        }
    }

    public static class LettuceClientConfigurationBuilder {
        boolean useSsl;
        boolean verifyPeer = true;
        boolean startTls;
        @Nullable
        ClientResources clientResources;
        @Nullable
        ClientOptions clientOptions;
        Duration timeout = Duration.ofSeconds(60L);
        Duration shutdownTimeout = Duration.ofMillis(100L);

        LettuceClientConfigurationBuilder() {
        }

        public LettuceSslClientConfigurationBuilder useSsl() {
            this.useSsl = true;
            return new LettuceSslClientConfigurationBuilder(this);
        }

        public LettuceClientConfigurationBuilder clientResources(ClientResources clientResources) {
            Assert.notNull((Object)clientResources, (String)"ClientResources must not be null!");
            this.clientResources = clientResources;
            return this;
        }

        public LettuceClientConfigurationBuilder clientOptions(ClientOptions clientOptions) {
            Assert.notNull((Object)clientOptions, (String)"ClientOptions must not be null!");
            this.clientOptions = clientOptions;
            return this;
        }

        public LettuceClientConfigurationBuilder commandTimeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"Duration must not be null!");
            this.timeout = timeout;
            return this;
        }

        public LettuceClientConfigurationBuilder shutdownTimeout(Duration shutdownTimeout) {
            Assert.notNull((Object)this.timeout, (String)"Duration must not be null!");
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public LettuceClientConfiguration build() {
            return new DefaultLettuceClientConfiguration(this.useSsl, this.verifyPeer, this.startTls, this.clientResources, this.clientOptions, this.timeout, this.shutdownTimeout);
        }
    }
}

