/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.GenericParameterService;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.MethodParameterPojoExtractor;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.converters.ConverterUtils;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;

public class SpringDocUtils {
    private static final SpringDocUtils springDocConfig = new SpringDocUtils();

    private SpringDocUtils() {
    }

    public static SpringDocUtils getConfig() {
        return springDocConfig;
    }

    public SpringDocUtils addDeprecatedType(Class<? extends Annotation> cls) {
        SchemaPropertyDeprecatingConverter.addDeprecatedType(cls);
        return this;
    }

    public SpringDocUtils addRestControllers(Class<?> ... classes) {
        AbstractOpenApiResource.addRestControllers(classes);
        return this;
    }

    public SpringDocUtils addHiddenRestControllers(Class<?> ... classes) {
        AbstractOpenApiResource.addHiddenRestControllers(classes);
        return this;
    }

    public SpringDocUtils addHiddenRestControllers(String ... classes) {
        AbstractOpenApiResource.addHiddenRestControllers(classes);
        return this;
    }

    public SpringDocUtils replaceWithClass(Class source, Class target) {
        AdditionalModelsConverter.replaceWithClass(source, target);
        return this;
    }

    public SpringDocUtils replaceWithSchema(Class source, Schema target) {
        AdditionalModelsConverter.replaceWithSchema(source, target);
        return this;
    }

    public SpringDocUtils addRequestWrapperToIgnore(Class<?> ... classes) {
        AbstractRequestService.addRequestWrapperToIgnore(classes);
        return this;
    }

    public SpringDocUtils removeRequestWrapperToIgnore(Class<?> ... classes) {
        AbstractRequestService.removeRequestWrapperToIgnore(classes);
        return this;
    }

    public SpringDocUtils addFileType(Class<?> ... classes) {
        GenericParameterService.addFileType(classes);
        return this;
    }

    public SpringDocUtils addResponseWrapperToIgnore(Class<?> cls) {
        ConverterUtils.addResponseWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeResponseWrapperToIgnore(Class<?> cls) {
        ConverterUtils.removeResponseWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils addResponseTypeToIgnore(Class<?> cls) {
        ConverterUtils.addResponseTypeToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeResponseTypeToIgnore(Class<?> cls) {
        ConverterUtils.removeResponseTypeToIgnore(cls);
        return this;
    }

    public SpringDocUtils addAnnotationsToIgnore(Class<?> ... classes) {
        SpringDocAnnotationsUtils.addAnnotationsToIgnore(classes);
        return this;
    }

    public SpringDocUtils removeAnnotationsToIgnore(Class<?> ... classes) {
        SpringDocAnnotationsUtils.removeAnnotationsToIgnore(classes);
        return this;
    }

    public SpringDocUtils addFluxWrapperToIgnore(Class<?> cls) {
        ConverterUtils.addFluxWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils removeFluxWrapperToIgnore(Class<?> cls) {
        ConverterUtils.removeFluxWrapperToIgnore(cls);
        return this;
    }

    public SpringDocUtils addSimpleTypesForParameterObject(Class<?> ... classes) {
        MethodParameterPojoExtractor.addSimpleTypes(classes);
        return this;
    }

    public SpringDocUtils removeSimpleTypesForParameterObject(Class<?> ... classes) {
        MethodParameterPojoExtractor.removeSimpleTypes(classes);
        return this;
    }

    public SpringDocUtils addSimpleTypePredicateForParameterObject(Predicate<Class<?>> predicate) {
        MethodParameterPojoExtractor.addSimpleTypePredicate(predicate);
        return this;
    }

    public SpringDocUtils disableReplacement(Class source) {
        AdditionalModelsConverter.disableReplacement(source);
        return this;
    }

    public SpringDocUtils replaceParameterObjectWithClass(Class source, Class target) {
        AdditionalModelsConverter.replaceParameterObjectWithClass(source, target);
        return this;
    }

    public SpringDocUtils setResponseEntityExceptionHandlerClass(Class<?> clazz) {
        GenericResponseService.setResponseEntityExceptionHandlerClass(clazz);
        return this;
    }

    public SpringDocUtils setModelAndViewClass(Class<?> clazz) {
        AbstractOpenApiResource.setModelAndViewClass(clazz);
        return this;
    }

    public SpringDocUtils removeFromSchemaMap(Class<?> clazzs) {
        AdditionalModelsConverter.removeFromSchemaMap(clazzs);
        return this;
    }

    public SpringDocUtils removeFromSchemaClass(Class<?> clazzs) {
        AdditionalModelsConverter.removeFromClassMap(clazzs);
        return this;
    }

    public SpringDocUtils addJavaTypeToIgnore(Class<?> clazz) {
        ConverterUtils.addJavaTypeToIgnore(clazz);
        return this;
    }

    public SpringDocUtils removeJavaTypeToIgnore(Class<?> clazz) {
        ConverterUtils.removeJavaTypeToIgnore(clazz);
        return this;
    }
}

