/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi.type.ordered;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.type.ordered.OrderedSPI;
import org.apache.shardingsphere.spi.type.ordered.cache.OrderedServicesCache;

public final class OrderedSPIRegistry {
    public static <T extends OrderedSPI<?>> Map<Class<?>, T> getRegisteredServicesByClass(Class<T> spiClass, Collection<Class<?>> types) {
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(spiClass);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type).forEach(type -> result.put(type, each));
        }
        return result;
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getRegisteredServices(Class<V> spiClass, Collection<K> types) {
        return OrderedSPIRegistry.getRegisteredServices(spiClass, types, Comparator.naturalOrder());
    }

    public static <K, V extends OrderedSPI<?>> Map<K, V> getRegisteredServices(Class<V> spiClass, Collection<K> types, Comparator<Integer> orderComparator) {
        Optional<Map> cachedServices = OrderedServicesCache.findCachedServices(spiClass, types).map(optional -> optional);
        if (cachedServices.isPresent()) {
            return cachedServices.get();
        }
        Collection<OrderedSPI> registeredServices = OrderedSPIRegistry.getRegisteredServices(spiClass, orderComparator);
        LinkedHashMap result = new LinkedHashMap(registeredServices.size(), 1.0f);
        for (OrderedSPI each : registeredServices) {
            types.stream().filter(type -> each.getTypeClass() == type.getClass()).forEach(type -> result.put(type, each));
        }
        OrderedServicesCache.cacheServices(spiClass, types, result);
        return result;
    }

    public static <T extends OrderedSPI<?>> Collection<T> getRegisteredServices(Class<T> spiClass) {
        return OrderedSPIRegistry.getRegisteredServices(spiClass, Comparator.naturalOrder());
    }

    private static <T extends OrderedSPI<?>> Collection<T> getRegisteredServices(Class<T> spiClass, Comparator<Integer> comparator) {
        TreeMap<Integer, OrderedSPI> result = new TreeMap<Integer, OrderedSPI>(comparator);
        for (OrderedSPI each : ShardingSphereServiceLoader.getServiceInstances(spiClass)) {
            Preconditions.checkArgument((!result.containsKey(each.getOrder()) ? 1 : 0) != 0, (String)"Found same order `%s` with `%s` and `%s`", (Object)each.getOrder(), result.get(each.getOrder()), (Object)each);
            result.put(each.getOrder(), each);
        }
        return result.values();
    }

    @Generated
    private OrderedSPIRegistry() {
    }
}

