/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler.update;

import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleEnabledException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.scaling.distsql.statement.EnableShardingScalingRuleStatement;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;

public final class EnableShardingScalingRuleStatementUpdater
implements RuleDefinitionAlterUpdater<EnableShardingScalingRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, EnableShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkExist(databaseName, sqlStatement, currentRuleConfig);
        this.checkEnabled(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Sharding", databaseName);
        }
    }

    private void checkExist(String databaseName, EnableShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (!currentRuleConfig.getScaling().containsKey(sqlStatement.getScalingName())) {
            throw new RequiredRuleMissedException("Scaling", databaseName, sqlStatement.getScalingName());
        }
    }

    private void checkEnabled(String databaseName, EnableShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null != currentRuleConfig.getScalingName() && currentRuleConfig.getScalingName().equals(sqlStatement.getScalingName())) {
            throw new RuleEnabledException("Scaling", databaseName, sqlStatement.getScalingName());
        }
    }

    public ShardingRuleConfiguration buildToBeAlteredRuleConfiguration(EnableShardingScalingRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setScalingName(sqlStatement.getScalingName());
        return result;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.setScalingName(toBeAlteredRuleConfig.getScalingName());
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return EnableShardingScalingRuleStatement.class.getName();
    }
}

