/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collections;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.parser.statement.CreateDefaultShadowAlgorithmStatement;

public final class CreateDefaultShadowAlgorithmStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDefaultShadowAlgorithmStatement, ShadowRuleConfiguration> {
    public RuleConfiguration buildToBeCreatedRuleConfiguration(CreateDefaultShadowAlgorithmStatement sqlStatement) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setDefaultShadowAlgorithmName(sqlStatement.getAlgorithmName());
        return result;
    }

    public void updateCurrentRuleConfiguration(ShadowRuleConfiguration currentRuleConfig, ShadowRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.setDefaultShadowAlgorithmName(toBeCreatedRuleConfig.getDefaultShadowAlgorithmName());
    }

    public void checkSQLStatement(ShardingSphereDatabase database, CreateDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        this.checkAlgorithmExist(database.getName(), sqlStatement, currentRuleConfig);
    }

    private void checkAlgorithmExist(String databaseName, CreateDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((boolean)currentRuleConfig.getShadowAlgorithms().containsKey(sqlStatement.getAlgorithmName()), () -> new RequiredAlgorithmMissedException(databaseName, Collections.singleton(sqlStatement.getAlgorithmName())));
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return CreateDefaultShadowAlgorithmStatement.class.getName();
    }
}

