/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class FederationDatabaseMetaData {
    private final String name;
    private final Map<String, FederationSchemaMetaData> schemas;

    public FederationDatabaseMetaData(String name, Map<String, ShardingSphereSchema> schemas) {
        this.name = name;
        this.schemas = new ConcurrentHashMap<String, FederationSchemaMetaData>(schemas.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereSchema> entry : schemas.entrySet()) {
            this.schemas.put(entry.getKey().toLowerCase(), new FederationSchemaMetaData(entry.getKey(), entry.getValue().getTables()));
        }
    }

    public void putSchemaMetadata(String schemaName, FederationSchemaMetaData schemaMetaData) {
        this.schemas.put(schemaName.toLowerCase(), schemaMetaData);
    }

    public void putTable(String schemaName, ShardingSphereTable table) {
        FederationSchemaMetaData schemaMetaData = this.schemas.computeIfAbsent(schemaName.toLowerCase(), key -> new FederationSchemaMetaData(schemaName, new LinkedHashMap<String, ShardingSphereTable>()));
        schemaMetaData.put(table);
    }

    public void removeSchemaMetadata(String schemaName) {
        this.schemas.remove(schemaName.toLowerCase());
    }

    public void removeTableMetadata(String schemaName, String tableName) {
        if (this.schemas.containsKey(schemaName.toLowerCase())) {
            this.schemas.get(schemaName.toLowerCase()).remove(tableName.toLowerCase());
        }
    }

    public Optional<FederationSchemaMetaData> getSchemaMetadata(String schemaName) {
        return Optional.of(this.schemas.get(schemaName));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, FederationSchemaMetaData> getSchemas() {
        return this.schemas;
    }
}

