/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.dubbo.alibaba;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.constants.DubboConstants;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"}, order=100)
public class AlibabaDubboTransactionProviderFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlibabaDubboTransactionProviderFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        block17: {
            if (!DubboConstants.ALIBABADUBBO) {
                return invoker.invoke(invocation);
            }
            String rpcXid = this.getRpcXid();
            String rpcBranchType = RpcContext.getContext().getAttachment("TX_BRANCH_TYPE");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xid in RpcContext[{}], branchType in RpcContext[{}]", (Object)rpcXid, (Object)rpcBranchType);
            }
            boolean bind = false;
            if (rpcXid != null) {
                RootContext.bind(rpcXid);
                if (StringUtils.equals(BranchType.TCC.name(), rpcBranchType)) {
                    RootContext.bindBranchType(BranchType.TCC);
                }
                bind = true;
            }
            try {
                result = invoker.invoke(invocation);
                if (!bind) break block17;
            }
            catch (Throwable throwable) {
                if (bind) {
                    BranchType previousBranchType = RootContext.getBranchType();
                    String unbindXid = RootContext.unbind();
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.unbindBranchType();
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
                    }
                    if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                        LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : BranchType.AT, previousBranchType});
                        if (unbindXid != null) {
                            RootContext.bind(unbindXid);
                            LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                            if (BranchType.TCC == previousBranchType) {
                                RootContext.bindBranchType(BranchType.TCC);
                                LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                            }
                        }
                    }
                }
                RpcContext.getServerContext().removeAttachment("TX_XID");
                RpcContext.getServerContext().removeAttachment("TX_BRANCH_TYPE");
                throw throwable;
            }
            BranchType previousBranchType = RootContext.getBranchType();
            String unbindXid = RootContext.unbind();
            if (BranchType.TCC == previousBranchType) {
                RootContext.unbindBranchType();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unbind xid [{}] branchType [{}] from RootContext", (Object)unbindXid, (Object)previousBranchType);
            }
            if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                LOGGER.warn("xid in change during RPC from {} to {},branchType from {} to {}", new Object[]{rpcXid, unbindXid, rpcBranchType != null ? rpcBranchType : BranchType.AT, previousBranchType});
                if (unbindXid != null) {
                    RootContext.bind(unbindXid);
                    LOGGER.warn("bind xid [{}] back to RootContext", (Object)unbindXid);
                    if (BranchType.TCC == previousBranchType) {
                        RootContext.bindBranchType(BranchType.TCC);
                        LOGGER.warn("bind branchType [{}] back to RootContext", (Object)previousBranchType);
                    }
                }
            }
        }
        RpcContext.getServerContext().removeAttachment("TX_XID");
        RpcContext.getServerContext().removeAttachment("TX_BRANCH_TYPE");
        return result;
    }

    private String getRpcXid() {
        String rpcXid = RpcContext.getContext().getAttachment("TX_XID");
        if (rpcXid == null) {
            rpcXid = RpcContext.getContext().getAttachment("TX_XID".toLowerCase());
        }
        return rpcXid;
    }
}

