/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.filters;

import io.quarkus.vertx.http.runtime.AbstractRequestWrapper;
import io.quarkus.vertx.http.runtime.filters.AbstractResponseWrapper;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;

public class QuarkusRequestWrapper
extends AbstractRequestWrapper {
    public static final String FAKE_COOKIE_NAME = "X-quarkus-request-wrapper";
    private static final Logger log = Logger.getLogger(QuarkusRequestWrapper.class);
    private volatile int done;
    private static final AtomicIntegerFieldUpdater<QuarkusRequestWrapper> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(QuarkusRequestWrapper.class, "done");
    private Handler<Throwable> exceptionHandler;
    private final AbstractResponseWrapper response;
    private final List<Handler<Void>> requestDoneHandlers = new ArrayList<Handler<Void>>();

    public QuarkusRequestWrapper(HttpServerRequest event) {
        super(event);
        this.response = new ResponseWrapper(this.delegate.response());
        event.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                if (QuarkusRequestWrapper.this.exceptionHandler != null) {
                    QuarkusRequestWrapper.this.exceptionHandler.handle((Object)event);
                }
                QuarkusRequestWrapper.this.done();
            }
        });
    }

    public static QuarkusRequestWrapper get(HttpServerRequest request) {
        return ((QuarkusCookie)request.getCookie(FAKE_COOKIE_NAME)).getRequestWrapper();
    }

    public void addRequestDoneHandler(Handler<Void> handler) {
        this.requestDoneHandlers.add(handler);
    }

    @Override
    public HttpServerResponse response() {
        return this.response;
    }

    void done() {
        if (doneUpdater.compareAndSet(this, 0, 1)) {
            for (Handler<Void> i : this.requestDoneHandlers) {
                try {
                    i.handle(null);
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to run " + i), t);
                }
            }
        }
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Cookie getCookie(String name) {
        if (name.equals(FAKE_COOKIE_NAME)) {
            return new QuarkusCookie();
        }
        return super.getCookie(name);
    }

    public class QuarkusCookie
    implements Cookie {
        public QuarkusRequestWrapper getRequestWrapper() {
            return QuarkusRequestWrapper.this;
        }

        public String getName() {
            return null;
        }

        public String getValue() {
            return null;
        }

        public Cookie setValue(String value) {
            return null;
        }

        public Cookie setDomain(String domain) {
            return null;
        }

        public String getDomain() {
            return null;
        }

        public Cookie setPath(String path) {
            return null;
        }

        public String getPath() {
            return null;
        }

        public Cookie setMaxAge(long maxAge) {
            return null;
        }

        public Cookie setSecure(boolean secure) {
            return null;
        }

        public Cookie setHttpOnly(boolean httpOnly) {
            return null;
        }

        public String encode() {
            return null;
        }
    }

    class ResponseWrapper
    extends AbstractResponseWrapper {
        Handler<Void> endHandler;
        Handler<Void> closeHandler;
        Handler<Throwable> exceptionHandler;

        ResponseWrapper(HttpServerResponse delegate) {
            super(delegate);
            delegate.closeHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    QuarkusRequestWrapper.this.done();
                    if (ResponseWrapper.this.closeHandler != null) {
                        ResponseWrapper.this.closeHandler.handle((Object)event);
                    }
                }
            });
            delegate.exceptionHandler((Handler)new Handler<Throwable>(){

                public void handle(Throwable event) {
                    QuarkusRequestWrapper.this.done();
                    if (ResponseWrapper.this.exceptionHandler != null) {
                        ResponseWrapper.this.exceptionHandler.handle((Object)event);
                    }
                }
            });
            delegate.endHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    QuarkusRequestWrapper.this.done();
                    if (ResponseWrapper.this.endHandler != null) {
                        ResponseWrapper.this.endHandler.handle((Object)event);
                    }
                }
            });
        }

        @Override
        public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public HttpServerResponse closeHandler(Handler<Void> handler) {
            this.closeHandler = handler;
            return this;
        }

        @Override
        public HttpServerResponse endHandler(Handler<Void> handler) {
            this.endHandler = handler;
            return this;
        }
    }
}

