/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

abstract class AbstractHttpClientMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractHttpClientMetricsHandler.class);
    String path;
    String method;
    String status;
    ContextView contextView;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;
    int lastReadSeq;
    int lastWriteSeq;

    protected AbstractHttpClientMetricsHandler(@Nullable Function<String, String> uriTagValue) {
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpClientMetricsHandler(AbstractHttpClientMetricsHandler copy) {
        this.contextView = copy.contextView;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.method = copy.method;
        this.path = copy.path;
        this.status = copy.status;
        this.uriTagValue = copy.uriTagValue;
        this.lastWriteSeq = copy.lastWriteSeq;
        this.lastReadSeq = copy.lastReadSeq;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        block4: {
            try {
                if (msg instanceof HttpRequest) {
                    this.extractDetailsFromHttpRequest(ctx, (HttpRequest)msg);
                }
                this.dataSent += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    int currentLastWriteSeq = this.lastWriteSeq;
                    SocketAddress address = ctx.channel().remoteAddress();
                    promise.addListener(future -> {
                        block3: {
                            try {
                                if (currentLastWriteSeq == this.lastWriteSeq) {
                                    this.lastWriteSeq = this.lastWriteSeq + 1 & Integer.MAX_VALUE;
                                    this.recordWrite(address);
                                }
                            }
                            catch (RuntimeException e) {
                                if (!log.isWarnEnabled()) break block3;
                                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        ctx.write(msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block5: {
            try {
                if (msg instanceof HttpResponse) {
                    this.status = ((HttpResponse)msg).status().codeAsText().toString();
                    this.dataReceivedTime = System.nanoTime();
                }
                this.dataReceived += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    this.lastReadSeq = this.lastReadSeq + 1 & Integer.MAX_VALUE;
                    if (this.lastReadSeq > this.lastWriteSeq || this.lastReadSeq == 0 && this.lastWriteSeq == Integer.MAX_VALUE) {
                        this.lastWriteSeq = this.lastWriteSeq + 1 & Integer.MAX_VALUE;
                        this.recordWrite(ctx.channel().remoteAddress());
                    }
                    this.recordRead(ctx.channel().remoteAddress());
                    this.reset();
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException(ctx);
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format((Channel)ctx.channel(), (String)"Exception caught while recording metrics."), (Throwable)e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    private void extractDetailsFromHttpRequest(ChannelHandlerContext ctx, HttpRequest request) {
        this.method = request.method().name();
        ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            HttpClientOperations ops = (HttpClientOperations)channelOps;
            this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
            this.contextView = ops.currentContextView();
        }
        this.dataSentTime = System.nanoTime();
    }

    private long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected abstract HttpClientMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx) {
        this.recorder().incrementErrorsCount(ctx.channel().remoteAddress(), this.path != null ? this.path : this.resolveUri(ctx));
    }

    protected void recordRead(SocketAddress address) {
        this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordResponseTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataReceived(address, this.path, this.dataReceived);
    }

    protected void recordWrite(SocketAddress address) {
        this.recorder().recordDataSentTime(address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataSent(address, this.path, this.dataSent);
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            String path = ((HttpClientOperations)channelOps).uri();
            return this.uriTagValue == null ? path : this.uriTagValue.apply(path);
        }
        return "unknown";
    }

    private void reset() {
        this.path = null;
        this.method = null;
        this.status = null;
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

