/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class LettuceFactories {
    private static final int ARRAY_QUEUE_THRESHOLD = Integer.getInteger("io.lettuce.core.LettuceFactories.array-queue-threshold", 200000);

    public static <T> Queue<T> newConcurrentQueue(int maxSize) {
        if (maxSize == Integer.MAX_VALUE) {
            return new ConcurrentLinkedQueue();
        }
        return maxSize > ARRAY_QUEUE_THRESHOLD ? new LinkedBlockingQueue(maxSize) : new ArrayBlockingQueue(maxSize);
    }

    public static <T> Deque<T> newSpScQueue() {
        return new ArrayDeque();
    }

    public static <T> LinkedBlockingQueue<T> newBlockingQueue() {
        return new LinkedBlockingQueue();
    }
}

