/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha2AllocationResult;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimConsumerReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.")
public class V1alpha2ResourceClaimStatus {
    public static final String SERIALIZED_NAME_ALLOCATION = "allocation";
    @SerializedName(value="allocation")
    private V1alpha2AllocationResult allocation;
    public static final String SERIALIZED_NAME_DEALLOCATION_REQUESTED = "deallocationRequested";
    @SerializedName(value="deallocationRequested")
    private Boolean deallocationRequested;
    public static final String SERIALIZED_NAME_DRIVER_NAME = "driverName";
    @SerializedName(value="driverName")
    private String driverName;
    public static final String SERIALIZED_NAME_RESERVED_FOR = "reservedFor";
    @SerializedName(value="reservedFor")
    private List<V1alpha2ResourceClaimConsumerReference> reservedFor = null;

    public V1alpha2ResourceClaimStatus allocation(V1alpha2AllocationResult allocation) {
        this.allocation = allocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2AllocationResult getAllocation() {
        return this.allocation;
    }

    public void setAllocation(V1alpha2AllocationResult allocation) {
        this.allocation = allocation;
    }

    public V1alpha2ResourceClaimStatus deallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DeallocationRequested indicates that a ResourceClaim is to be deallocated.  The driver then must deallocate this claim and reset the field together with clearing the Allocation field.  While DeallocationRequested is set, no new consumers may be added to ReservedFor.")
    public Boolean getDeallocationRequested() {
        return this.deallocationRequested;
    }

    public void setDeallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
    }

    public V1alpha2ResourceClaimStatus driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.")
    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public V1alpha2ResourceClaimStatus reservedFor(List<V1alpha2ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
        return this;
    }

    public V1alpha2ResourceClaimStatus addReservedForItem(V1alpha2ResourceClaimConsumerReference reservedForItem) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList<V1alpha2ResourceClaimConsumerReference>();
        }
        this.reservedFor.add(reservedForItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.  There can be at most 32 such reservations. This may get increased in the future, but not reduced.")
    public List<V1alpha2ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor;
    }

    public void setReservedFor(List<V1alpha2ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClaimStatus v1alpha2ResourceClaimStatus = (V1alpha2ResourceClaimStatus)o;
        return Objects.equals(this.allocation, v1alpha2ResourceClaimStatus.allocation) && Objects.equals(this.deallocationRequested, v1alpha2ResourceClaimStatus.deallocationRequested) && Objects.equals(this.driverName, v1alpha2ResourceClaimStatus.driverName) && Objects.equals(this.reservedFor, v1alpha2ResourceClaimStatus.reservedFor);
    }

    public int hashCode() {
        return Objects.hash(this.allocation, this.deallocationRequested, this.driverName, this.reservedFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClaimStatus {\n");
        sb.append("    allocation: ").append(this.toIndentedString(this.allocation)).append("\n");
        sb.append("    deallocationRequested: ").append(this.toIndentedString(this.deallocationRequested)).append("\n");
        sb.append("    driverName: ").append(this.toIndentedString(this.driverName)).append("\n");
        sb.append("    reservedFor: ").append(this.toIndentedString(this.reservedFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

