/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.utils;

import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;

public class ApplicationUtils
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static ApplicationContext applicationContext;
    private static boolean started;

    public static boolean isStarted() {
        return started;
    }

    public static void setStarted(boolean started) {
        ApplicationUtils.started = started;
    }

    public static Object getBean(String name) throws BeansException {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)applicationContext.getBean(name, requiredType);
    }

    public static Object getBean(String name, Object ... args) throws BeansException {
        return applicationContext.getBean(name, args);
    }

    public static <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> void getBeanIfExist(Class<T> requiredType, Consumer<T> consumer) throws BeansException {
        try {
            Object bean = applicationContext.getBean(requiredType);
            consumer.accept(bean);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    public static <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return (T)applicationContext.getBean(requiredType, args);
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return applicationContext.getType(name);
    }

    public static void publishEvent(Object event) {
        applicationContext.publishEvent(event);
    }

    public static Resource[] getResources(String locationPattern) throws IOException {
        return applicationContext.getResources(locationPattern);
    }

    public static Resource getResource(String location) {
        return applicationContext.getResource(location);
    }

    public static ClassLoader getClassLoader() {
        return applicationContext.getClassLoader();
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void injectContext(ConfigurableApplicationContext context) {
        applicationContext = context;
    }

    public void initialize(ConfigurableApplicationContext context) {
        if (null == applicationContext) {
            applicationContext = context;
        } else if (context.getParent() == applicationContext) {
            applicationContext = context;
        }
    }

    static {
        started = false;
    }
}

