/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.filter;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.sys.filter.NacosPackageExcludeFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;

public class NacosTypeExcludeFilter
implements TypeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosTypeExcludeFilter.class);
    private final Map<String, NacosPackageExcludeFilter> packageExcludeFilters = new HashMap<String, NacosPackageExcludeFilter>(2);

    public NacosTypeExcludeFilter() {
        for (NacosPackageExcludeFilter each : NacosServiceLoader.load(NacosPackageExcludeFilter.class)) {
            this.packageExcludeFilters.put(each.getResponsiblePackagePrefix(), each);
            LOGGER.info("Load Nacos package exclude filter success, package prefix {}, filter {}", (Object)each.getResponsiblePackagePrefix(), (Object)each.getClass().getCanonicalName());
        }
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        if (this.packageExcludeFilters.isEmpty()) {
            return false;
        }
        boolean isSpringBootApplication = metadataReader.getAnnotationMetadata().hasAnnotation(SpringBootApplication.class.getCanonicalName());
        String className = metadataReader.getClassMetadata().getClassName();
        if (isSpringBootApplication) {
            LOGGER.info("Skip @SpringBootApplication annotation for class {} to avoid duplicate scan", (Object)className);
            return true;
        }
        for (Map.Entry<String, NacosPackageExcludeFilter> entry : this.packageExcludeFilters.entrySet()) {
            if (!className.startsWith(entry.getKey())) continue;
            Set annotations = metadataReader.getAnnotationMetadata().getAnnotationTypes();
            return entry.getValue().isExcluded(className, annotations);
        }
        return false;
    }
}

