/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.prometheus.utils;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PrometheusUtils {
    public static void assembleArrayNodes(Set<Instance> targetSet, ArrayNode arrayNode) {
        Map<String, List<Instance>> groupingInsMap = targetSet.stream().collect(Collectors.groupingBy(Instance::getClusterName));
        groupingInsMap.forEach((key, value) -> {
            for (Instance instance : value) {
                ObjectNode jsonNode = PrometheusUtils.assembleInstanceToArrayNode(key, instance);
                arrayNode.add((JsonNode)jsonNode);
            }
        });
    }

    private static ObjectNode assembleInstanceToArrayNode(String clusterName, Instance instance) {
        ArrayNode targetsNode = JacksonUtils.createEmptyArrayNode();
        targetsNode.add(instance.getIp() + ":" + instance.getPort());
        ObjectNode labelNode = JacksonUtils.createEmptyJsonNode();
        labelNode.put("__meta_clusterName", clusterName);
        Map<String, String> metadata = instance.getMetadata();
        metadata = metadata.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).replace(".", "_").replace("-", "_"), e -> (String)e.getValue()));
        metadata.forEach((arg_0, arg_1) -> ((ObjectNode)labelNode).put(arg_0, arg_1));
        ObjectNode jsonNode = JacksonUtils.createEmptyJsonNode();
        jsonNode.replace("targets", (JsonNode)targetsNode);
        jsonNode.replace("labels", (JsonNode)labelNode);
        return jsonNode;
    }
}

