/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.repository.embedded.sql.limiter;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.persistence.repository.embedded.sql.ModifyRequest;
import com.alibaba.nacos.persistence.repository.embedded.sql.SelectRequest;
import com.alibaba.nacos.persistence.repository.embedded.sql.limiter.SqlLimiter;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SqlTypeLimiter
implements SqlLimiter {
    private static final String ENABLED_SQL_LIMIT = "nacos.persistence.sql.derby.limit.enabled";
    private final Set<String> allowedDmlSqls;
    private final Set<String> allowedDdlSqls;
    private final Set<String> allowedDdlScopes;
    private final boolean enabledLimit = (Boolean)EnvUtil.getProperty((String)"nacos.persistence.sql.derby.limit.enabled", Boolean.class, (Object)true);

    public SqlTypeLimiter() {
        this.allowedDmlSqls = new HashSet<String>(4);
        this.allowedDmlSqls.add("INSERT");
        this.allowedDmlSqls.add("UPDATE");
        this.allowedDmlSqls.add("DELETE");
        this.allowedDmlSqls.add("SELECT");
        this.allowedDdlSqls = new HashSet<String>(2);
        this.allowedDdlSqls.add("CREATE");
        this.allowedDdlSqls.add("ALTER");
        this.allowedDdlScopes = new HashSet<String>(3);
        this.allowedDdlScopes.add("SCHEMA");
        this.allowedDdlScopes.add("TABLE");
        this.allowedDdlScopes.add("INDEX");
    }

    @Override
    public void doLimitForModifyRequest(ModifyRequest modifyRequest) throws SQLException {
        if (null == modifyRequest || !this.enabledLimit) {
            return;
        }
        this.doLimit(modifyRequest.getSql());
    }

    @Override
    public void doLimitForModifyRequest(List<ModifyRequest> modifyRequests) throws SQLException {
        if (null == modifyRequests || !this.enabledLimit) {
            return;
        }
        for (ModifyRequest each : modifyRequests) {
            this.doLimitForModifyRequest(each);
        }
    }

    @Override
    public void doLimitForSelectRequest(SelectRequest selectRequest) throws SQLException {
        if (null == selectRequest || !this.enabledLimit) {
            return;
        }
        this.doLimit(selectRequest.getSql());
    }

    @Override
    public void doLimitForSelectRequest(List<SelectRequest> selectRequests) throws SQLException {
        if (null == selectRequests || !this.enabledLimit) {
            return;
        }
        for (SelectRequest each : selectRequests) {
            this.doLimitForSelectRequest(each);
        }
    }

    @Override
    public void doLimit(String sql) throws SQLException {
        String firstToken;
        if (!this.enabledLimit) {
            return;
        }
        String trimmedSql = sql.trim();
        if (StringUtils.isEmpty((String)trimmedSql)) {
            return;
        }
        int firstTokenIndex = trimmedSql.indexOf(" ");
        if (-1 == firstTokenIndex) {
            this.throwException(trimmedSql);
        }
        if (this.allowedDmlSqls.contains(firstToken = trimmedSql.substring(0, firstTokenIndex).toUpperCase())) {
            return;
        }
        if (!this.allowedDdlSqls.contains(firstToken)) {
            this.throwException(trimmedSql);
        }
        this.checkSqlForSecondToken(firstTokenIndex, trimmedSql);
    }

    @Override
    public void doLimit(List<String> sql) throws SQLException {
        if (null == sql || !this.enabledLimit) {
            return;
        }
        for (String each : sql) {
            this.doLimit(each);
        }
    }

    private void throwException(String sql) throws SQLException {
        throw new SQLException(String.format("Unsupported SQL: %s. Nacos only support DML and some DDL SQL.", sql));
    }

    private void checkSqlForSecondToken(int firstTokenIndex, String trimmedSql) throws SQLException {
        String secondToken;
        int secondTokenIndex = trimmedSql.indexOf(" ", firstTokenIndex + 1);
        if (-1 == secondTokenIndex) {
            secondTokenIndex = trimmedSql.length();
        }
        if (!this.allowedDdlScopes.contains(secondToken = trimmedSql.substring(firstTokenIndex + 1, secondTokenIndex).toUpperCase())) {
            this.throwException(trimmedSql);
        }
    }
}

