/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.v2.processor;

import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Mysql;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.v2.HealthCheckTaskV2;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckCommonV2;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckProcessorV2;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.springframework.stereotype.Component;

@Component
public class MysqlHealthCheckProcessor
implements HealthCheckProcessorV2 {
    public static final String TYPE = HealthCheckType.MYSQL.name();
    private final HealthCheckCommonV2 healthCheckCommon;
    private final SwitchDomain switchDomain;
    public static final int CONNECT_TIMEOUT_MS = 500;
    private static final String CHECK_MYSQL_MASTER_SQL = "show global variables where variable_name='read_only'";
    private static final String MYSQL_SLAVE_READONLY = "ON";
    private static final ConcurrentMap<String, Connection> CONNECTION_POOL = new ConcurrentHashMap<String, Connection>();

    public MysqlHealthCheckProcessor(HealthCheckCommonV2 healthCheckCommon, SwitchDomain switchDomain) {
        this.healthCheckCommon = healthCheckCommon;
        this.switchDomain = switchDomain;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void process(HealthCheckTaskV2 task, Service service, ClusterMetadata metadata) {
        HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)task.getClient().getInstancePublishInfo(service);
        if (null == instance) {
            return;
        }
        Loggers.SRV_LOG.debug("mysql check, ip:" + String.valueOf(instance));
        try {
            if (!instance.tryStartCheck()) {
                Loggers.SRV_LOG.warn("mysql check started before last one finished, service: {} : {} : {}:{}", new Object[]{service.getGroupedServiceName(), instance.getCluster(), instance.getIp(), instance.getPort()});
                this.healthCheckCommon.reEvaluateCheckRt(task.getCheckRtNormalized() * 2L, task, this.switchDomain.getMysqlHealthParams());
                return;
            }
            GlobalExecutor.executeMysqlCheckTask(new MysqlCheckTask(task, service, instance, metadata));
            MetricsMonitor.getMysqlHealthCheckMonitor().incrementAndGet();
        }
        catch (Exception e) {
            instance.setCheckRt(this.switchDomain.getMysqlHealthParams().getMax());
            this.healthCheckCommon.checkFail(task, service, "mysql:error:" + e.getMessage());
            this.healthCheckCommon.reEvaluateCheckRt(this.switchDomain.getMysqlHealthParams().getMax(), task, this.switchDomain.getMysqlHealthParams());
        }
    }

    private class MysqlCheckTask
    implements Runnable {
        private final HealthCheckTaskV2 task;
        private final Service service;
        private final HealthCheckInstancePublishInfo instance;
        private final ClusterMetadata metadata;
        private long startTime = System.currentTimeMillis();

        public MysqlCheckTask(HealthCheckTaskV2 task, Service service, HealthCheckInstancePublishInfo instance, ClusterMetadata metadata) {
            this.task = task;
            this.service = service;
            this.instance = instance;
            this.metadata = metadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String clusterName = this.instance.getCluster();
                String key = this.service.getGroupedServiceName() + ":" + clusterName + ":" + this.instance.getIp() + ":" + this.instance.getPort();
                Connection connection = (Connection)CONNECTION_POOL.get(key);
                Mysql config = (Mysql)this.metadata.getHealthChecker();
                if (connection == null || connection.isClosed()) {
                    String url = "jdbc:mysql://" + this.instance.getIp() + ":" + this.instance.getPort() + "?connectTimeout=500&socketTimeout=500&loginTimeout=1";
                    connection = DriverManager.getConnection(url, config.getUser(), config.getPwd());
                    CONNECTION_POOL.put(key, connection);
                }
                statement = connection.createStatement();
                statement.setQueryTimeout(1);
                resultSet = statement.executeQuery(config.getCmd());
                int resultColumnIndex = 2;
                if (MysqlHealthCheckProcessor.CHECK_MYSQL_MASTER_SQL.equals(config.getCmd())) {
                    resultSet.next();
                    if (MysqlHealthCheckProcessor.MYSQL_SLAVE_READONLY.equals(resultSet.getString(resultColumnIndex))) {
                        throw new IllegalStateException("current node is slave!");
                    }
                }
                MysqlHealthCheckProcessor.this.healthCheckCommon.checkOk(this.task, this.service, "mysql:+ok");
                MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRt(System.currentTimeMillis() - this.startTime, this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
            }
            catch (SQLException e) {
                MysqlHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.task, this.service, "mysql:" + e.getMessage());
                MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRt(MysqlHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
            }
            catch (Throwable t) {
                Throwable cause = t;
                int maxStackDepth = 50;
                for (int deepth = 0; deepth < maxStackDepth && cause != null; cause = cause.getCause(), ++deepth) {
                    if (!(cause instanceof SocketTimeoutException) && !(cause instanceof ConnectException) && !(cause instanceof TimeoutException) && !(cause.getCause() instanceof TimeoutException)) continue;
                    MysqlHealthCheckProcessor.this.healthCheckCommon.checkFail(this.task, this.service, "mysql:timeout:" + cause.getMessage());
                    MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRt(this.task.getCheckRtNormalized() * 2L, this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
                    return;
                }
                MysqlHealthCheckProcessor.this.healthCheckCommon.checkFail(this.task, this.service, "mysql:error:" + t.getMessage());
                MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRt(MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams().getMax(), this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
            }
            finally {
                this.instance.setCheckRt(System.currentTimeMillis() - this.startTime);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        Loggers.SRV_LOG.error("[MYSQL-CHECK] failed to close statement:" + String.valueOf(statement), (Throwable)e);
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        Loggers.SRV_LOG.error("[MYSQL-CHECK] failed to close resultSet:" + String.valueOf(resultSet), (Throwable)e);
                    }
                }
            }
        }
    }
}

