/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.model.VirtualService;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.google.protobuf.Any;
import io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import io.envoyproxy.envoy.config.route.v3.RedirectAction;
import io.envoyproxy.envoy.config.route.v3.Route;
import io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.envoyproxy.envoy.config.route.v3.RouteMatch;
import io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.envoyproxy.envoy.service.discovery.v3.Resource;
import io.envoyproxy.envoy.type.matcher.v3.RegexMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class RdsGenerator
implements ApiGenerator<Any> {
    public static final String DEFAULT_ROUTE_CONFIGURATION = "default_route_configuration";
    public static final String CONFIG_REASON = "config";
    public static final String DOMAIN_SUFFIX = ".nacos";
    public static final String ROUTE_CONFIGURATION_SUFFIX = "_route_config";
    public static final String BOOTSTRAP_UPSTREAM_CLUSTER = "nacos_xds";
    private final Yaml yaml = new Yaml();
    private static volatile RdsGenerator singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RdsGenerator getInstance() {
        if (singleton != null) return singleton;
        Class<RdsGenerator> clazz = RdsGenerator.class;
        synchronized (RdsGenerator.class) {
            if (singleton != null) return singleton;
            singleton = new RdsGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public List<Any> generate(PushRequest pushRequest) {
        ArrayList<Any> result = new ArrayList<Any>();
        Set<String> reasons = pushRequest.getReason();
        if (reasons.contains(DEFAULT_ROUTE_CONFIGURATION)) {
            reasons.stream().filter(reason -> !DEFAULT_ROUTE_CONFIGURATION.equals(reason)).forEach(reason -> result.add(RdsGenerator.buildDefaultRouteConfiguration(reason)));
        } else if (reasons.contains(CONFIG_REASON)) {
            reasons.stream().filter(reason -> !CONFIG_REASON.equals(reason)).forEach(reason -> {
                VirtualService vs = this.parseContent((String)reason, (Class)VirtualService.class);
                result.add(RdsGenerator.generateRdsFromVirtualService(vs, pushRequest));
            });
        } else {
            reasons.forEach(reason -> result.add(RdsGenerator.buildDefaultRouteConfiguration(reason)));
        }
        return result;
    }

    @Override
    public List<Resource> deltaGenerate(PushRequest pushRequest) {
        return null;
    }

    private static Any buildDefaultRouteConfiguration(String routeConfigurationName) {
        if (routeConfigurationName == null) {
            throw new IllegalArgumentException("routeConfigurationName cannot be null");
        }
        String virtualHostName = routeConfigurationName;
        if (routeConfigurationName.endsWith(ROUTE_CONFIGURATION_SUFFIX)) {
            virtualHostName = routeConfigurationName.substring(0, routeConfigurationName.length() - ROUTE_CONFIGURATION_SUFFIX.length());
        }
        RouteConfiguration routeConfiguration = RouteConfiguration.newBuilder().setName(routeConfigurationName).addVirtualHosts(VirtualHost.newBuilder().setName(virtualHostName).addDomains("*").addRoutes(Route.newBuilder().setMatch(RouteMatch.newBuilder().setPrefix("/").build()).setRoute(RouteAction.newBuilder().setCluster(BOOTSTRAP_UPSTREAM_CLUSTER).build()).build()).build()).build();
        return Any.newBuilder().setValue(routeConfiguration.toByteString()).setTypeUrl("type.googleapis.com/envoy.config.route.v3.RouteConfiguration").build();
    }

    public static Any generateRdsFromVirtualService(VirtualService virtualService, PushRequest pushRequest) {
        List<VirtualService.Spec.Http> httpRoutes = virtualService.getSpec().getHttp();
        List<String> hosts = virtualService.getSpec().getHosts();
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        List<String> hostnames = RdsGenerator.getMatchingHostnames(hosts, pushRequest);
        String virtualHostName = virtualService.getMetadata().getName();
        for (Map.Entry<String, IstioService> entry : istioServiceMap.entrySet()) {
            if (!entry.getKey().contains(virtualHostName)) continue;
            virtualHostName = IstioCrdUtil.buildClusterName(TrafficDirection.OUTBOUND, "", (String)entry.getKey() + DOMAIN_SUFFIX, ((IstioService)entry.getValue()).getPort());
            Loggers.MAIN.info("Setting virtualHostName: {}", (Object)virtualHostName);
        }
        VirtualHost.Builder virtualHostBuilder = VirtualHost.newBuilder().setName(virtualHostName).addAllDomains(hostnames);
        for (VirtualService.Spec.Http httpRoute : httpRoutes) {
            RdsGenerator.processHttpRoute(httpRoute, virtualHostBuilder, pushRequest);
        }
        RouteConfiguration routeConfiguration = RouteConfiguration.newBuilder().setName(virtualService.getMetadata().getName() + ROUTE_CONFIGURATION_SUFFIX).addVirtualHosts(virtualHostBuilder).build();
        return Any.newBuilder().setValue(routeConfiguration.toByteString()).setTypeUrl("type.googleapis.com/envoy.config.route.v3.RouteConfiguration").build();
    }

    private <T> T parseContent(String content, Class<T> valueType) {
        return (T)this.yaml.loadAs(content, valueType);
    }

    private static List<String> getMatchingHostnames(List<String> hosts, PushRequest pushRequest) {
        ArrayList<String> hostnames = new ArrayList<String>();
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        for (String host : hosts) {
            if ("*".equals(host)) {
                hostnames.add("*");
                break;
            }
            for (Map.Entry<String, IstioService> entry : istioServiceMap.entrySet()) {
                if (!entry.getKey().contains(host)) continue;
                String hostname = IstioCrdUtil.buildClusterName(TrafficDirection.OUTBOUND, "", host + DOMAIN_SUFFIX, entry.getValue().getPort());
                Loggers.MAIN.info("Matching hostname: {}", (Object)hostname);
                hostnames.add(hostname);
            }
        }
        return hostnames;
    }

    private static void processHttpRoute(VirtualService.Spec.Http httpRoute, VirtualHost.Builder virtualHostBuilder, PushRequest pushRequest) {
        Route.Builder routeBuilder = Route.newBuilder();
        if (httpRoute.getName() != null) {
            routeBuilder.setName(httpRoute.getName());
        }
        for (VirtualService.Spec.Http.Match match : httpRoute.getMatch()) {
            RouteMatch.Builder routeMatchBuilder = RouteMatch.newBuilder();
            if (match.getUri().getPrefix() != null) {
                routeMatchBuilder.setPrefix(match.getUri().getPrefix());
            } else if (match.getUri().getExact() != null) {
                routeMatchBuilder.setPath(match.getUri().getExact());
            } else if (match.getUri().getRegex() != null) {
                RegexMatcher regexMatcher = RegexMatcher.newBuilder().setRegex(match.getUri().getRegex()).build();
                routeMatchBuilder.setSafeRegex(regexMatcher);
            }
            routeBuilder.setMatch(routeMatchBuilder);
        }
        if (httpRoute.getRedirect() != null) {
            RdsGenerator.setRedirectAction(httpRoute.getRedirect(), routeBuilder);
        } else {
            RdsGenerator.setRouteAction(httpRoute, routeBuilder, pushRequest);
        }
        virtualHostBuilder.addRoutes(routeBuilder);
    }

    private static void setRouteAction(VirtualService.Spec.Http httpRoute, Route.Builder routeBuilder, PushRequest pushRequest) {
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        RouteAction.Builder routeActionBuilder = RouteAction.newBuilder();
        String hostName = httpRoute.getRoute().get(0).getDestination().getHost();
        if (httpRoute.getRewrite() != null) {
            routeActionBuilder.setPrefixRewrite(httpRoute.getRewrite().getUri());
        }
        String destName = hostName;
        for (Map.Entry<String, IstioService> entry : istioServiceMap.entrySet()) {
            if (!entry.getKey().contains(hostName)) continue;
            destName = IstioCrdUtil.buildClusterName(TrafficDirection.OUTBOUND, "", entry.getKey() + DOMAIN_SUFFIX, entry.getValue().getPort());
            Loggers.MAIN.info("Setting route action to destination: {}", (Object)destName);
        }
        routeBuilder.setRoute(routeActionBuilder.setCluster(destName));
    }

    private static void setRedirectAction(VirtualService.Spec.Http.Redirect redirect, Route.Builder routeBuilder) {
        RedirectAction.Builder redirectBuilder = RedirectAction.newBuilder();
        if (redirect.getUri() != null) {
            redirectBuilder.setPathRedirect(redirect.getUri());
        }
        if (redirect.getAuthority() != null) {
            redirectBuilder.setHostRedirect(redirect.getAuthority());
        }
        routeBuilder.setRedirect(redirectBuilder);
    }
}

