/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.PushRequest;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import io.envoyproxy.envoy.config.accesslog.v3.AccessLog;
import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.config.core.v3.AggregatedConfigSource;
import io.envoyproxy.envoy.config.core.v3.ConfigSource;
import io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.envoyproxy.envoy.config.listener.v3.Filter;
import io.envoyproxy.envoy.config.listener.v3.FilterChain;
import io.envoyproxy.envoy.config.listener.v3.Listener;
import io.envoyproxy.envoy.config.route.v3.Route;
import io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.envoyproxy.envoy.config.route.v3.RouteMatch;
import io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.envoyproxy.envoy.extensions.filters.http.router.v3.Router;
import io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager;
import io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpFilter;
import io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import io.envoyproxy.envoy.service.discovery.v3.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LdsGenerator
implements ApiGenerator<Any> {
    public static final String INIT_LISTENER = "bootstrap_listener";
    private static final String INIT_LISTENER_NAME = "listener_0";
    private static final String INIT_LISTENER_ADDRESS = "0.0.0.0";
    private static final int INIT_LISTENER_PORT = 80;
    private static final String ACCESS_LOGGER_NAME = "envoy.access_loggers.stdout";
    private static final String TYPE_URL_ACCESS_LOG = "type.googleapis.com/envoy.extensions.access_loggers.stream.v3.StdoutAccessLog";
    private static final int DEFAULT_PORT_INCREMENT = 1;
    public static final String ROUTE_CONFIGURATION_SUFFIX = "_route_config";
    public static final String BOOTSTRAP_UPSTREAM_CLUSTER = "nacos_xds";
    public static final String DEFAULT_FILTER_CHAIN_NAME = "filter_chain_0";
    public static final String DEFAULT_FILTER_TYPE = "envoy.filters.network.http_connection_manager";
    public static final String DEFAULT_HTTPMANAGER_PREFIX = "ingress_http";
    public static final String DEFAULT_HTTP_ROUTER_TYPE = "envoy.filters.http.router";
    private static volatile LdsGenerator singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LdsGenerator getInstance() {
        if (singleton != null) return singleton;
        Class<LdsGenerator> clazz = LdsGenerator.class;
        synchronized (LdsGenerator.class) {
            if (singleton != null) return singleton;
            singleton = new LdsGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public List<Any> generate(PushRequest pushRequest) {
        if (!pushRequest.isFull()) {
            return null;
        }
        Map<String, IstioService> istioServiceMap = pushRequest.getResourceSnapshot().getIstioResources().getIstioServiceMap();
        ArrayList<Any> result = new ArrayList<Any>();
        result.add(LdsGenerator.buildBootstrapListener());
        if (pushRequest.isFull()) {
            for (Map.Entry<String, IstioService> entry : istioServiceMap.entrySet()) {
                IstioService istioService = entry.getValue();
                if (istioService != null) {
                    String rdsName = entry.getKey() + ROUTE_CONFIGURATION_SUFFIX;
                    result.add(LdsGenerator.buildDynamicListener(entry.getKey(), INIT_LISTENER_ADDRESS, istioService.getPort(), rdsName));
                    continue;
                }
                Loggers.MAIN.error("Attempt to create listener for non-existent service");
            }
        }
        return result;
    }

    @Override
    public List<Resource> deltaGenerate(PushRequest pushRequest) {
        return null;
    }

    private static Any buildDefaultListener(String listenerName, String listenerAddress, int listenerPort, String rdsName, boolean isBootstrap) {
        if (LdsGenerator.isValid(listenerName, listenerPort, rdsName, isBootstrap)) {
            Loggers.MAIN.error("Listener name, Listener port and RDS name cannot be null.");
            return null;
        }
        Listener.Builder listenerBuilder = Listener.newBuilder().setName(listenerName);
        listenerAddress = listenerAddress == null ? INIT_LISTENER_ADDRESS : listenerAddress;
        int portValue = isBootstrap ? 80 : listenerPort + 1;
        listenerBuilder.setAddress(Address.newBuilder().setSocketAddress(SocketAddress.newBuilder().setAddress(listenerAddress).setPortValue(portValue)));
        Object routeConfigName = isBootstrap ? "bootstrap_listener_route_config" : listenerName + ROUTE_CONFIGURATION_SUFFIX;
        String virtualHostName = isBootstrap ? INIT_LISTENER : listenerName;
        RouteConfiguration routeConfiguration = RouteConfiguration.newBuilder().setName((String)routeConfigName).addVirtualHosts(VirtualHost.newBuilder().setName(virtualHostName).addDomains("*").addRoutes(Route.newBuilder().setMatch(RouteMatch.newBuilder().setPrefix("/").build()).setRoute(RouteAction.newBuilder().setCluster(BOOTSTRAP_UPSTREAM_CLUSTER).build()).build()).build()).build();
        HttpConnectionManager httpConnectionManager = HttpConnectionManager.newBuilder().setStatPrefix(DEFAULT_HTTPMANAGER_PREFIX).addAccessLog(LdsGenerator.buildAccessLog()).setCodecType(HttpConnectionManager.CodecType.AUTO).setRouteConfig(routeConfiguration).addHttpFilters(LdsGenerator.createHttpFilter()).build();
        listenerBuilder.addFilterChains(LdsGenerator.createFilterChain(httpConnectionManager));
        Listener listener = listenerBuilder.build();
        return Any.newBuilder().setValue(listener.toByteString()).setTypeUrl("type.googleapis.com/envoy.config.listener.v3.Listener").build();
    }

    private static Any buildBootstrapListener() {
        return LdsGenerator.buildDefaultListener(INIT_LISTENER_NAME, INIT_LISTENER_ADDRESS, 80, null, true);
    }

    private static Any buildDefaultStaticListener(String listenerName, String listenerAddress, int listenerPort, String rdsName) {
        if (INIT_LISTENER.equals(listenerName)) {
            return LdsGenerator.buildBootstrapListener();
        }
        return LdsGenerator.buildDefaultListener(listenerName, listenerAddress, listenerPort, rdsName, false);
    }

    private static Any buildDynamicListener(String listenerName, String listenerAddress, int listenerPort, String rdsName) {
        if (INIT_LISTENER.equals(listenerName)) {
            return LdsGenerator.buildBootstrapListener();
        }
        if (listenerName == null || listenerPort == 0 || rdsName == null) {
            Loggers.MAIN.error("Listener name, Listener port and RDS name cannot be null.");
            return null;
        }
        listenerAddress = listenerAddress == null ? INIT_LISTENER_ADDRESS : listenerAddress;
        Listener.Builder listenerBuilder = Listener.newBuilder().setName(listenerName);
        listenerBuilder.setAddress(Address.newBuilder().setSocketAddress(SocketAddress.newBuilder().setAddress(listenerAddress).setPortValue(listenerPort + 1)));
        ConfigSource configSource = LdsGenerator.createConfigSource();
        Rds rds = Rds.newBuilder().setConfigSource(configSource).setRouteConfigName(rdsName).build();
        HttpConnectionManager httpConnectionManager = HttpConnectionManager.newBuilder().setStatPrefix(DEFAULT_HTTPMANAGER_PREFIX).addAccessLog(LdsGenerator.buildAccessLog()).setCodecType(HttpConnectionManager.CodecType.AUTO).setRds(rds).addHttpFilters(LdsGenerator.createHttpFilter()).build();
        listenerBuilder.addFilterChains(LdsGenerator.createFilterChain(httpConnectionManager));
        Listener listener = listenerBuilder.build();
        return Any.newBuilder().setValue(listener.toByteString()).setTypeUrl("type.googleapis.com/envoy.config.listener.v3.Listener").build();
    }

    private static AccessLog buildAccessLog() {
        return AccessLog.newBuilder().setName(ACCESS_LOGGER_NAME).setTypedConfig(Any.newBuilder().setTypeUrl(TYPE_URL_ACCESS_LOG).setValue(ByteString.EMPTY).build()).build();
    }

    private static ConfigSource createConfigSource() {
        return ConfigSource.newBuilder().setAds(AggregatedConfigSource.newBuilder()).setResourceApiVersionValue(1).build();
    }

    private static HttpFilter createHttpFilter() {
        return HttpFilter.newBuilder().setName(DEFAULT_HTTP_ROUTER_TYPE).setTypedConfig(Any.pack(Router.newBuilder().build())).build();
    }

    private static FilterChain createFilterChain(HttpConnectionManager httpConnectionManager) {
        return FilterChain.newBuilder().setName(DEFAULT_FILTER_CHAIN_NAME).addFilters(Filter.newBuilder().setName(DEFAULT_FILTER_TYPE).setTypedConfig(Any.pack(httpConnectionManager))).build();
    }

    private static boolean isValid(String listenerName, int listenerPort, String rdsName, boolean isBootstrap) {
        return !isBootstrap && (listenerName == null || listenerPort == 0 || rdsName == null);
    }
}

