/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.model;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.istio.model.IstioEndpoint;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IstioService {
    private final String name;
    private final String groupName;
    private final String namespace;
    private final Long revision;
    private int port = 0;
    private String protocol;
    private final List<IstioEndpoint> hosts;
    private final Date createTimeStamp;

    public IstioService(Service service, ServiceInfo serviceInfo) {
        this.name = serviceInfo.getName();
        this.groupName = serviceInfo.getGroupName();
        this.namespace = service.getNamespace();
        this.revision = service.getRevision();
        this.createTimeStamp = new Date();
        this.hosts = this.sanitizeServiceInfo(serviceInfo);
    }

    public IstioService(Service service, ServiceInfo serviceInfo, IstioService old) {
        this.name = serviceInfo.getName();
        this.groupName = serviceInfo.getGroupName();
        this.namespace = service.getNamespace();
        this.revision = service.getRevision();
        this.createTimeStamp = old.getCreateTimeStamp();
        this.hosts = this.sanitizeServiceInfo(serviceInfo);
    }

    private List<IstioEndpoint> sanitizeServiceInfo(ServiceInfo serviceInfo) {
        IstioEndpoint istioEndpoint;
        ArrayList<IstioEndpoint> hosts = new ArrayList<IstioEndpoint>();
        for (Instance instance : serviceInfo.getHosts()) {
            if (!instance.isHealthy() || !instance.isEnabled()) continue;
            istioEndpoint = new IstioEndpoint(instance);
            if (this.port == 0) {
                this.port = istioEndpoint.getPort();
                this.protocol = istioEndpoint.getProtocol();
            }
            hosts.add(istioEndpoint);
        }
        if (hosts.isEmpty()) {
            for (Instance instance : serviceInfo.getHosts()) {
                istioEndpoint = new IstioEndpoint(instance);
                hosts.add(istioEndpoint);
            }
        }
        return hosts;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Long getRevision() {
        return this.revision;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public List<IstioEndpoint> getHosts() {
        return this.hosts;
    }

    public Date getCreateTimeStamp() {
        return this.createTimeStamp;
    }
}

