/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisherFactory;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.istio.common.Debounce;
import com.alibaba.nacos.istio.common.EventProcessor;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.model.PushRequest;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.alibaba.nacos.istio.util.IstioExecutor;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.core.v2.event.metadata.InfoChangeEvent;
import com.alibaba.nacos.naming.core.v2.event.publisher.NamingEventPublisherFactory;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NacosServiceInfoResourceWatcher
extends SmartSubscriber {
    private final Map<String, IstioService> serviceInfoMap = new ConcurrentHashMap<String, IstioService>(16);
    private final Queue<PushRequest> pushRequestQueue = new ConcurrentLinkedQueue<PushRequest>();
    private boolean isInitial = true;
    @Autowired
    private IstioConfig istioConfig;
    @Autowired
    private ServiceStorage serviceStorage;
    @Autowired
    private EventProcessor eventProcessor;

    public NacosServiceInfoResourceWatcher() {
        NotifyCenter.registerSubscriber((Subscriber)this, (EventPublisherFactory)NamingEventPublisherFactory.getInstance());
    }

    public Map<String, IstioService> snapshot() {
        return new HashMap<String, IstioService>(this.serviceInfoMap);
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ClientOperationEvent.ClientRegisterServiceEvent.class);
        result.add(ClientOperationEvent.ClientDeregisterServiceEvent.class);
        result.add(InfoChangeEvent.ServiceInfoChangeEvent.class);
        result.add(InfoChangeEvent.InstanceInfoChangeEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (this.isInitial) {
            this.init();
            this.isInitial = false;
            IstioExecutor.cycleDebounce(new ToNotify());
        }
        if (event instanceof ClientOperationEvent.ClientRegisterServiceEvent) {
            ClientOperationEvent.ClientRegisterServiceEvent clientRegisterServiceEvent = (ClientOperationEvent.ClientRegisterServiceEvent)event;
            com.alibaba.nacos.naming.core.v2.pojo.Service service = clientRegisterServiceEvent.getService();
            String serviceName = IstioCrdUtil.buildServiceName(service);
            IstioService old = this.serviceInfoMap.get(serviceName);
            boolean full = this.update(serviceName, service);
            PushRequest pushRequest = old != null ? new PushRequest(serviceName, full) : new PushRequest(serviceName, true);
            this.pushRequestQueue.add(pushRequest);
        } else if (event instanceof ClientOperationEvent.ClientDeregisterServiceEvent) {
            PushRequest pushRequest;
            ClientOperationEvent.ClientDeregisterServiceEvent clientDeregisterServiceEvent = (ClientOperationEvent.ClientDeregisterServiceEvent)event;
            com.alibaba.nacos.naming.core.v2.pojo.Service service = clientDeregisterServiceEvent.getService();
            String serviceName = IstioCrdUtil.buildServiceName(service);
            boolean full = this.update(serviceName, service);
            if (this.serviceStorage.getPushData(service).ipCount() <= 0) {
                pushRequest = new PushRequest(serviceName, true);
                this.serviceInfoMap.remove(serviceName);
            } else {
                pushRequest = new PushRequest(serviceName, full);
            }
            this.pushRequestQueue.add(pushRequest);
        } else if (event instanceof InfoChangeEvent.ServiceInfoChangeEvent) {
            InfoChangeEvent.ServiceInfoChangeEvent serviceInfoChangeEvent = (InfoChangeEvent.ServiceInfoChangeEvent)event;
            com.alibaba.nacos.naming.core.v2.pojo.Service service = serviceInfoChangeEvent.getService();
            String serviceName = IstioCrdUtil.buildServiceName(service);
            PushRequest pushRequest = new PushRequest(serviceName, true);
            this.update(serviceName, service);
            this.pushRequestQueue.add(pushRequest);
        } else if (event instanceof InfoChangeEvent.InstanceInfoChangeEvent) {
            InfoChangeEvent.InstanceInfoChangeEvent instanceInfoChangeEvent = (InfoChangeEvent.InstanceInfoChangeEvent)event;
            com.alibaba.nacos.naming.core.v2.pojo.Service service = instanceInfoChangeEvent.getService();
            String serviceName = IstioCrdUtil.buildServiceName(service);
            boolean full = this.update(serviceName, service);
            PushRequest pushRequest = new PushRequest(serviceName, full);
            this.pushRequestQueue.add(pushRequest);
        }
    }

    private void init() {
        Set namespaces = ServiceManager.getInstance().getAllNamespaces();
        for (String namespace : namespaces) {
            Set services = ServiceManager.getInstance().getSingletons(namespace);
            if (services.isEmpty()) continue;
            for (com.alibaba.nacos.naming.core.v2.pojo.Service service : services) {
                String serviceName = IstioCrdUtil.buildServiceName(service);
                ServiceInfo serviceInfo = this.serviceStorage.getPushData(service);
                if (!serviceInfo.isValid()) continue;
                this.serviceInfoMap.put(serviceName, new IstioService(service, serviceInfo));
                this.pushRequestQueue.add(new PushRequest(serviceName, true));
            }
        }
    }

    private boolean update(String serviceName, com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        ServiceInfo serviceInfo = this.serviceStorage.getPushData(service);
        if (!serviceInfo.isValid()) {
            this.serviceInfoMap.remove(serviceName);
            return true;
        }
        IstioService old = this.serviceInfoMap.get(serviceName);
        if (old != null) {
            this.serviceInfoMap.put(serviceName, new IstioService(service, serviceInfo, old));
        } else {
            this.serviceInfoMap.put(serviceName, new IstioService(service, serviceInfo));
        }
        return false;
    }

    private class ToNotify
    implements Runnable {
        private ToNotify() {
        }

        @Override
        public void run() {
            while (true) {
                if (NacosServiceInfoResourceWatcher.this.pushRequestQueue.size() <= 0) {
                    continue;
                }
                Future<PushRequest> futureUpdate = IstioExecutor.debouncePushChange(new Debounce(NacosServiceInfoResourceWatcher.this.pushRequestQueue, NacosServiceInfoResourceWatcher.this.istioConfig));
                try {
                    PushRequest updatePush = futureUpdate.get();
                    if (updatePush == null) continue;
                    NacosServiceInfoResourceWatcher.this.eventProcessor.notify(updatePush);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

