/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.mapper;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public abstract class AbstractMapper
implements Mapper {
    private static final String COLUMN_SEPARATOR = "@";

    @Override
    public String select(List<String> columns, List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "SELECT ";
        sql.append(method);
        sql.append(String.join((CharSequence)",", columns));
        sql.append(" FROM ");
        sql.append(this.getTableName());
        if (CollectionUtils.isEmpty(where)) {
            return sql.toString();
        }
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String insert(List<String> columns) {
        StringJoiner columnJoiner = new StringJoiner(", ", "(", ")");
        StringJoiner valueJoiner = new StringJoiner(",", "(", ")");
        for (String col : columns) {
            String[] parts = col.split(COLUMN_SEPARATOR, 2);
            columnJoiner.add(parts[0]);
            valueJoiner.add(parts.length > 1 ? this.getFunction(parts[1]) : "?");
        }
        return "INSERT INTO " + this.getTableName() + String.valueOf(columnJoiner) + " VALUES" + String.valueOf(valueJoiner);
    }

    @Override
    public String update(List<String> columns, List<String> where) {
        StringJoiner setJoiner = new StringJoiner(",");
        for (String col : columns) {
            String[] parts = col.split(COLUMN_SEPARATOR, 2);
            String value = parts.length > 1 ? this.getFunction(parts[1]) : "?";
            setJoiner.add(parts[0] + " = " + value);
        }
        StringBuilder sql = new StringBuilder("UPDATE ").append(this.getTableName()).append(" SET ").append(setJoiner);
        if (CollectionUtils.isNotEmpty(where)) {
            this.appendWhereClause(where, sql);
        }
        return sql.toString();
    }

    @Override
    public String delete(List<String> params) {
        StringBuilder sql = new StringBuilder();
        String method = "DELETE ";
        sql.append(method).append("FROM ").append(this.getTableName());
        this.appendWhereClause(params, sql);
        return sql.toString();
    }

    @Override
    public String count(List<String> where) {
        StringBuilder sql = new StringBuilder();
        String method = "SELECT ";
        sql.append(method);
        sql.append("COUNT(*) FROM ");
        sql.append(this.getTableName());
        if (CollectionUtils.isEmpty(where)) {
            return sql.toString();
        }
        this.appendWhereClause(where, sql);
        return sql.toString();
    }

    @Override
    public String[] getPrimaryKeyGeneratedKeys() {
        return new String[]{"id"};
    }

    private void appendWhereClause(List<String> where, StringBuilder sql) {
        sql.append(" WHERE ");
        sql.append(where.stream().map(str -> str + " = ?").collect(Collectors.joining(" AND ")));
    }
}

