/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.impl.mysql;

import com.alibaba.nacos.common.utils.ArrayUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.datasource.impl.mysql.AbstractMapperByMysql;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ext.WhereBuilder;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;

public class ConfigInfoMapperByMySql
extends AbstractMapperByMysql
implements ConfigInfoMapper {
    private static final String DATA_ID = "dataId";
    private static final String GROUP = "group";
    private static final String APP_NAME = "appName";
    private static final String CONTENT = "content";
    private static final String TENANT = "tenant";

    @Override
    public MapperResult findConfigInfoByAppFetchRows(MapperContext context) {
        String appName = (String)context.getWhereParameter("app_name");
        String tenantId = (String)context.getWhereParameter("tenantId");
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE tenant_id LIKE ? AND app_name= ? LIMIT " + context.getStartRow() + "," + context.getPageSize();
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{tenantId, appName}));
    }

    @Override
    public MapperResult getTenantIdList(MapperContext context) {
        String sql = "SELECT tenant_id FROM config_info WHERE tenant_id != '" + NamespaceUtil.getNamespaceDefaultId() + "' GROUP BY tenant_id LIMIT " + context.getStartRow() + "," + context.getPageSize();
        return new MapperResult(sql, Collections.emptyList());
    }

    @Override
    public MapperResult getGroupIdList(MapperContext context) {
        String sql = "SELECT group_id FROM config_info WHERE tenant_id ='" + NamespaceUtil.getNamespaceDefaultId() + "' GROUP BY group_id LIMIT " + context.getStartRow() + "," + context.getPageSize();
        return new MapperResult(sql, Collections.emptyList());
    }

    @Override
    public MapperResult findAllConfigKey(MapperContext context) {
        String sql = " SELECT data_id,group_id,app_name  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT " + context.getStartRow() + "," + context.getPageSize() + " ) g, config_info t WHERE g.id = t.id  ";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult findAllConfigInfoBaseFetchRows(MapperContext context) {
        String sql = "SELECT t.id,data_id,group_id,content,md5 FROM ( SELECT id FROM config_info ORDER BY id LIMIT " + context.getStartRow() + "," + context.getPageSize() + " ) g, config_info t  WHERE g.id = t.id ";
        return new MapperResult(sql, Collections.emptyList());
    }

    @Override
    public MapperResult findAllConfigInfoFragment(MapperContext context) {
        String contextParameter = context.getContextParameter("needContent");
        boolean needContent = contextParameter != null && Boolean.parseBoolean(contextParameter);
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name," + (needContent ? "content," : "") + "md5,gmt_modified,type,encrypted_data_key FROM config_info WHERE id > ? ORDER BY id ASC LIMIT " + context.getStartRow() + "," + context.getPageSize();
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("id")}));
    }

    @Override
    public MapperResult findChangeConfigFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter(DATA_ID);
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        Timestamp startTime = (Timestamp)context.getWhereParameter("startTime");
        Timestamp endTime = (Timestamp)context.getWhereParameter("endTime");
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,type,md5,gmt_modified FROM config_info WHERE ";
        Object where = " 1=1 ";
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = (String)where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = (String)where + " AND group_id LIKE ? ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            where = (String)where + " AND tenant_id = ? ";
            paramList.add(tenantTmp);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            where = (String)where + " AND app_name = ? ";
            paramList.add(appName);
        }
        if (startTime != null) {
            where = (String)where + " AND gmt_modified >=? ";
            paramList.add(startTime);
        }
        if (endTime != null) {
            where = (String)where + " AND gmt_modified <=? ";
            paramList.add(endTime);
        }
        return new MapperResult("SELECT id,data_id,group_id,tenant_id,app_name,type,md5,gmt_modified FROM config_info WHERE " + (String)where + " AND id > " + String.valueOf(context.getWhereParameter("lastMaxId")) + " ORDER BY id ASC LIMIT 0," + context.getPageSize(), paramList);
    }

    @Override
    public MapperResult listGroupKeyMd5ByPageFetchRows(MapperContext context) {
        String sql = "SELECT t.id,data_id,group_id,tenant_id,app_name,md5,type,gmt_modified,encrypted_data_key FROM ( SELECT id FROM config_info ORDER BY id LIMIT " + context.getStartRow() + "," + context.getPageSize() + " ) g, config_info t WHERE g.id = t.id";
        return new MapperResult(sql, Collections.emptyList());
    }

    @Override
    public MapperResult findConfigInfoBaseLikeFetchRows(MapperContext context) {
        String dataId = (String)context.getWhereParameter(DATA_ID);
        String group = (String)context.getWhereParameter("groupId");
        String content = (String)context.getWhereParameter(CONTENT);
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE ";
        String where = " 1=1 AND tenant_id='" + NamespaceUtil.getNamespaceDefaultId() + "' ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            where = where + " AND data_id LIKE ? ";
            paramList.add(dataId);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            where = where + " AND group_id LIKE ";
            paramList.add(group);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where = where + " AND content LIKE ? ";
            paramList.add(content);
        }
        return new MapperResult("SELECT id,data_id,group_id,tenant_id,content FROM config_info WHERE " + where + " LIMIT " + context.getStartRow() + "," + context.getPageSize(), paramList);
    }

    @Override
    public MapperResult findConfigInfo4PageFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter(DATA_ID);
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String content = (String)context.getWhereParameter(CONTENT);
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = "SELECT id,data_id,group_id,tenant_id,app_name,content,md5,type,encrypted_data_key FROM config_info";
        StringBuilder where = new StringBuilder(" WHERE ");
        where.append(" tenant_id=? ");
        paramList.add(tenant);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.append(" AND data_id=? ");
            paramList.add(dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.append(" AND group_id=? ");
            paramList.add(group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.append(" AND app_name=? ");
            paramList.add(appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            where.append(" AND content LIKE ? ");
            paramList.add(content);
        }
        return new MapperResult("SELECT id,data_id,group_id,tenant_id,app_name,content,md5,type,encrypted_data_key FROM config_info" + String.valueOf(where) + " LIMIT " + context.getStartRow() + "," + context.getPageSize(), paramList);
    }

    @Override
    public MapperResult findConfigInfoBaseByGroupFetchRows(MapperContext context) {
        String sql = "SELECT id,data_id,group_id,content FROM config_info WHERE group_id=? AND tenant_id=? LIMIT " + context.getStartRow() + "," + context.getPageSize();
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("groupId"), context.getWhereParameter("tenantId")}));
    }

    @Override
    public MapperResult findConfigInfoLike4PageFetchRows(MapperContext context) {
        String tenant = (String)context.getWhereParameter("tenantId");
        String dataId = (String)context.getWhereParameter(DATA_ID);
        String group = (String)context.getWhereParameter("groupId");
        String appName = (String)context.getWhereParameter("app_name");
        String content = (String)context.getWhereParameter(CONTENT);
        Object[] types = (String[])context.getWhereParameter("type");
        WhereBuilder where = new WhereBuilder("SELECT id,data_id,group_id,tenant_id,app_name,content,md5,encrypted_data_key,type FROM config_info");
        where.like("tenant_id", tenant);
        if (StringUtils.isNotBlank((String)dataId)) {
            where.and().like("data_id", dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            where.and().like("group_id", group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            where.and().eq("app_name", appName);
        }
        if (StringUtils.isNotBlank((String)content)) {
            where.and().like(CONTENT, content);
        }
        if (!ArrayUtils.isEmpty((Object[])types)) {
            where.and().in("type", types);
        }
        where.limit(context.getStartRow(), context.getPageSize());
        return where.build();
    }

    @Override
    public MapperResult findAllConfigInfoFetchRows(MapperContext context) {
        String sql = "SELECT t.id,data_id,group_id,tenant_id,app_name,content,md5  FROM (  SELECT id FROM config_info WHERE tenant_id LIKE ? ORDER BY id LIMIT ?,? ) g, config_info t  WHERE g.id = t.id ";
        return new MapperResult(sql, CollectionUtils.list((Object[])new Object[]{context.getWhereParameter("tenantId"), context.getStartRow(), context.getPageSize()}));
    }

    @Override
    public String getDataSource() {
        return "mysql";
    }
}

