/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.enums.derby;

import java.util.HashMap;
import java.util.Map;

public enum TrustedDerbylFunctionEnum {
    NOW("NOW()", "CURRENT_TIMESTAMP");

    private static final Map<String, TrustedDerbylFunctionEnum> LOOKUP_MAP;
    private final String functionName;
    private final String function;

    private TrustedDerbylFunctionEnum(String functionName, String function) {
        this.functionName = functionName;
        this.function = function;
    }

    public static String getFunctionByName(String functionName) {
        TrustedDerbylFunctionEnum entry = LOOKUP_MAP.get(functionName);
        if (entry != null) {
            return entry.function;
        }
        throw new IllegalArgumentException(String.format("Invalid function name: %s", functionName));
    }

    static {
        LOOKUP_MAP = new HashMap<String, TrustedDerbylFunctionEnum>();
        for (TrustedDerbylFunctionEnum entry : TrustedDerbylFunctionEnum.values()) {
            LOOKUP_MAP.put(entry.functionName, entry);
        }
    }
}

