/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import jakarta.servlet.http.HttpServletRequest;

public class RequestUtil {
    public static final String CLIENT_APPNAME_HEADER = "Client-AppName";

    public static String getRemoteIp(HttpServletRequest request) {
        String remoteIp = RequestContextHolder.getContext().getBasicContext().getAddressContext().getSourceIp();
        if (StringUtils.isBlank((CharSequence)remoteIp)) {
            remoteIp = RequestContextHolder.getContext().getBasicContext().getAddressContext().getRemoteIp();
        }
        if (StringUtils.isBlank((CharSequence)remoteIp)) {
            remoteIp = WebUtils.getRemoteIp((HttpServletRequest)request);
        }
        return remoteIp;
    }

    public static String getAppName(HttpServletRequest request) {
        String result = RequestContextHolder.getContext().getBasicContext().getApp();
        return RequestUtil.isUnknownApp(result) ? request.getHeader(CLIENT_APPNAME_HEADER) : result;
    }

    private static boolean isUnknownApp(String appName) {
        return StringUtils.isBlank((CharSequence)appName) || StringUtils.equalsIgnoreCase((String)"unknown", (String)appName);
    }

    public static String getSrcUserName(HttpServletRequest request) {
        IdentityContext identityContext = RequestContextHolder.getContext().getAuthContext().getIdentityContext();
        String result = "";
        if (null != identityContext) {
            result = (String)identityContext.getParameter("identity_id");
        }
        return StringUtils.isBlank((CharSequence)result) ? request.getParameter("username") : result;
    }
}

