/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class PropertyUtil
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger LOGGER = LogUtil.DEFAULT_LOG;
    private static int notifyConnectTimeout = 100;
    private static int notifySocketTimeout = 200;
    private static int maxHealthCheckFailCount = 12;
    private static boolean isHealthCheck = true;
    private static int maxContent = 0xA00000;
    private static boolean isManageCapacity = true;
    private static boolean grayCompatibleModel = true;
    public static final ThreadLocal<Boolean> GRAY_MIGRATE_FLAG = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> CONFIG_MIGRATE_FLAG = ThreadLocal.withInitial(() -> false);
    private static boolean isCapacityLimitCheck = false;
    private static int defaultClusterQuota = 100000;
    private static int defaultGroupQuota = 200;
    private static int defaultTenantQuota = 200;
    private static int defaultMaxSize = 102400;
    private static int defaultMaxAggrCount = 10000;
    private static int defaultMaxAggrSize = 1024;
    private static int initialExpansionPercent = 100;
    private static int correctUsageDelay = 600;
    private static boolean dumpChangeOn = true;
    private static int configRententionDays = 30;
    private static long dumpChangeWorkerInterval = 30000L;
    private static final int MAX_DUMP_PAGE = 1000;
    private static final int MIN_DUMP_PAGE = 50;
    private static final int PAGE_MEMORY_DIVIDE_MB = 512;
    private static AtomicInteger allDumpPageSize;
    private static String limitMemoryFile;

    public static boolean isDumpChangeOn() {
        return dumpChangeOn;
    }

    public static void setDumpChangeOn(boolean dumpChangeOn) {
        PropertyUtil.dumpChangeOn = dumpChangeOn;
    }

    public static long getDumpChangeWorkerInterval() {
        return dumpChangeWorkerInterval;
    }

    public static void setDumpChangeWorkerInterval(long dumpChangeWorkerInterval) {
        PropertyUtil.dumpChangeWorkerInterval = dumpChangeWorkerInterval;
    }

    public static int getNotifyConnectTimeout() {
        return notifyConnectTimeout;
    }

    public static void setNotifyConnectTimeout(int notifyConnectTimeout) {
        PropertyUtil.notifyConnectTimeout = notifyConnectTimeout;
    }

    public static int getNotifySocketTimeout() {
        return notifySocketTimeout;
    }

    public static void setNotifySocketTimeout(int notifySocketTimeout) {
        PropertyUtil.notifySocketTimeout = notifySocketTimeout;
    }

    public static int getMaxHealthCheckFailCount() {
        return maxHealthCheckFailCount;
    }

    public static void setMaxHealthCheckFailCount(int maxHealthCheckFailCount) {
        PropertyUtil.maxHealthCheckFailCount = maxHealthCheckFailCount;
    }

    public static boolean isHealthCheck() {
        return isHealthCheck;
    }

    public static void setHealthCheck(boolean isHealthCheck) {
        PropertyUtil.isHealthCheck = isHealthCheck;
    }

    public static int getMaxContent() {
        return maxContent;
    }

    public static void setMaxContent(int maxContent) {
        PropertyUtil.maxContent = maxContent;
    }

    public static boolean isManageCapacity() {
        return isManageCapacity;
    }

    public static void setManageCapacity(boolean isManageCapacity) {
        PropertyUtil.isManageCapacity = isManageCapacity;
    }

    public static int getDefaultClusterQuota() {
        return defaultClusterQuota;
    }

    public static void setDefaultClusterQuota(int defaultClusterQuota) {
        PropertyUtil.defaultClusterQuota = defaultClusterQuota;
    }

    public static boolean isCapacityLimitCheck() {
        return isCapacityLimitCheck;
    }

    public static void setCapacityLimitCheck(boolean isCapacityLimitCheck) {
        PropertyUtil.isCapacityLimitCheck = isCapacityLimitCheck;
    }

    public static int getDefaultGroupQuota() {
        return defaultGroupQuota;
    }

    public static void setDefaultGroupQuota(int defaultGroupQuota) {
        PropertyUtil.defaultGroupQuota = defaultGroupQuota;
    }

    public static int getDefaultTenantQuota() {
        return defaultTenantQuota;
    }

    public static void setDefaultTenantQuota(int defaultTenantQuota) {
        PropertyUtil.defaultTenantQuota = defaultTenantQuota;
    }

    public static int getInitialExpansionPercent() {
        return initialExpansionPercent;
    }

    public static void setInitialExpansionPercent(int initialExpansionPercent) {
        PropertyUtil.initialExpansionPercent = initialExpansionPercent;
    }

    public static int getDefaultMaxSize() {
        return defaultMaxSize;
    }

    public static void setDefaultMaxSize(int defaultMaxSize) {
        PropertyUtil.defaultMaxSize = defaultMaxSize;
    }

    public static int getDefaultMaxAggrCount() {
        return defaultMaxAggrCount;
    }

    public static void setDefaultMaxAggrCount(int defaultMaxAggrCount) {
        PropertyUtil.defaultMaxAggrCount = defaultMaxAggrCount;
    }

    public static boolean isGrayCompatibleModel() {
        return grayCompatibleModel;
    }

    public static void setGrayCompatibleModel(boolean grayCompatibleModel) {
        PropertyUtil.grayCompatibleModel = grayCompatibleModel;
    }

    public static int getDefaultMaxAggrSize() {
        return defaultMaxAggrSize;
    }

    public static void setDefaultMaxAggrSize(int defaultMaxAggrSize) {
        PropertyUtil.defaultMaxAggrSize = defaultMaxAggrSize;
    }

    public static int getCorrectUsageDelay() {
        return correctUsageDelay;
    }

    public static void setCorrectUsageDelay(int correctUsageDelay) {
        PropertyUtil.correctUsageDelay = correctUsageDelay;
    }

    public static int getConfigRententionDays() {
        return configRententionDays;
    }

    private void setConfigRententionDays() {
        String val = this.getProperty("nacos.config.retention.days");
        if (null != val) {
            int tmp = 0;
            try {
                tmp = Integer.parseInt(val);
                if (tmp > 0) {
                    configRententionDays = tmp;
                }
            }
            catch (NumberFormatException nfe) {
                LogUtil.FATAL_LOG.error("read nacos.config.retention.days wrong", (Throwable)nfe);
            }
        }
    }

    public static boolean isStandaloneMode() {
        return EnvUtil.getStandaloneMode();
    }

    private void loadSetting() {
        try {
            PropertyUtil.setNotifyConnectTimeout(Integer.parseInt(EnvUtil.getProperty((String)"notifyConnectTimeout", (String)String.valueOf(notifyConnectTimeout))));
            LOGGER.info("notifyConnectTimeout:{}", (Object)notifyConnectTimeout);
            PropertyUtil.setNotifySocketTimeout(Integer.parseInt(EnvUtil.getProperty((String)"notifySocketTimeout", (String)String.valueOf(notifySocketTimeout))));
            LOGGER.info("notifySocketTimeout:{}", (Object)notifySocketTimeout);
            PropertyUtil.setHealthCheck(Boolean.parseBoolean(EnvUtil.getProperty((String)"isHealthCheck", (String)String.valueOf(isHealthCheck))));
            LOGGER.info("isHealthCheck:{}", (Object)isHealthCheck);
            PropertyUtil.setMaxHealthCheckFailCount(Integer.parseInt(EnvUtil.getProperty((String)"maxHealthCheckFailCount", (String)String.valueOf(maxHealthCheckFailCount))));
            LOGGER.info("maxHealthCheckFailCount:{}", (Object)maxHealthCheckFailCount);
            PropertyUtil.setMaxContent(Integer.parseInt(EnvUtil.getProperty((String)"maxContent", (String)String.valueOf(maxContent))));
            LOGGER.info("maxContent:{}", (Object)maxContent);
            PropertyUtil.setManageCapacity(this.getBoolean("isManageCapacity", isManageCapacity));
            PropertyUtil.setCapacityLimitCheck(this.getBoolean("isCapacityLimitCheck", isCapacityLimitCheck));
            PropertyUtil.setDefaultClusterQuota(this.getInt("defaultClusterQuota", defaultClusterQuota));
            PropertyUtil.setDefaultGroupQuota(this.getInt("defaultGroupQuota", defaultGroupQuota));
            PropertyUtil.setDefaultTenantQuota(this.getInt("defaultTenantQuota", defaultTenantQuota));
            PropertyUtil.setDefaultMaxSize(this.getInt("defaultMaxSize", defaultMaxSize));
            PropertyUtil.setDefaultMaxAggrCount(this.getInt("defaultMaxAggrCount", defaultMaxAggrCount));
            PropertyUtil.setDefaultMaxAggrSize(this.getInt("defaultMaxAggrSize", defaultMaxAggrSize));
            PropertyUtil.setCorrectUsageDelay(this.getInt("correctUsageDelay", correctUsageDelay));
            PropertyUtil.setInitialExpansionPercent(this.getInt("initialExpansionPercent", initialExpansionPercent));
            this.setConfigRententionDays();
            PropertyUtil.setDumpChangeOn(this.getBoolean("dumpChangeOn", dumpChangeOn));
            PropertyUtil.setDumpChangeWorkerInterval(this.getLong("dumpChangeWorkerInterval", dumpChangeWorkerInterval));
            PropertyUtil.setGrayCompatibleModel(this.getBoolean("nacos.config.gray.compatible.model", grayCompatibleModel));
        }
        catch (Exception e) {
            LOGGER.error("read application.properties failed", (Throwable)e);
            throw e;
        }
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(key, String.valueOf(defaultValue)));
    }

    private int getInt(String key, int defaultValue) {
        return Integer.parseInt(this.getString(key, String.valueOf(defaultValue)));
    }

    private long getLong(String key, long defaultValue) {
        return Long.parseLong(this.getString(key, String.valueOf(defaultValue)));
    }

    private String getString(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        LOGGER.info("{}:{}", (Object)key, (Object)value);
        return value;
    }

    public String getProperty(String key) {
        return EnvUtil.getProperty((String)key);
    }

    public String getProperty(String key, String defaultValue) {
        return EnvUtil.getProperty((String)key, (String)defaultValue);
    }

    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        this.loadSetting();
    }

    public static int getAllDumpPageSize() {
        if (allDumpPageSize == null) {
            allDumpPageSize = new AtomicInteger(PropertyUtil.initAllDumpPageSize());
        }
        return allDumpPageSize.get();
    }

    static int initAllDumpPageSize() {
        long memLimitMb = PropertyUtil.getMemLimitMb();
        int pageSize = (int)((float)memLimitMb / 512.0f) * 50;
        pageSize = Math.max(pageSize, 50);
        pageSize = Math.min(pageSize, 1000);
        LOGGER.info("All dump page size is set to {} according to mem limit {} MB", (Object)pageSize, (Object)memLimitMb);
        return pageSize;
    }

    public static long getMemLimitMb() {
        Optional<Long> memoryLimit = PropertyUtil.findMemoryLimitFromFile();
        if (memoryLimit.isPresent()) {
            return memoryLimit.get();
        }
        memoryLimit = PropertyUtil.findMemoryLimitFromSystem();
        return memoryLimit.get();
    }

    private static Optional<Long> findMemoryLimitFromFile() {
        Optional<Long> optional;
        if (limitMemoryFile == null) {
            limitMemoryFile = EnvUtil.getProperty((String)"memory_limit_file_path", (String)"/sys/fs/cgroup/memory/memory.limit_in_bytes");
        }
        File file = new File(limitMemoryFile);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            long memoryLimit = Long.parseLong(reader.readLine().trim());
            optional = Optional.of(memoryLimit / 1024L / 1024L);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NumberFormatException ignored) {
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    private static Optional<Long> findMemoryLimitFromSystem() {
        long maxHeapSizeMb = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        return Optional.of(maxHeapSizeMb);
    }
}

