/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigExtInfoUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigExtInfoUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Map<String, String> EXTRA_INFO_KEYS_MAPPING = new HashMap<String, String>();

    private ConfigExtInfoUtil() {
    }

    public static String getExtraInfoFromAdvanceInfoMap(Map<String, Object> advanceConfigInfoMap, String srcUser) {
        try {
            if (advanceConfigInfoMap == null || advanceConfigInfoMap.isEmpty()) {
                return null;
            }
            ObjectNode node = OBJECT_MAPPER.createObjectNode();
            if (StringUtils.isNotBlank((String)srcUser)) {
                node.put("src_user", srcUser);
            }
            for (Map.Entry<String, String> entry : EXTRA_INFO_KEYS_MAPPING.entrySet()) {
                String key = entry.getKey();
                String mappedKey = entry.getValue();
                Object advanceConfigInfoValue = advanceConfigInfoMap.get(key);
                if (!(advanceConfigInfoValue instanceof String) || !StringUtils.isNotBlank((String)((String)advanceConfigInfoValue))) continue;
                node.put(mappedKey, ((String)advanceConfigInfoValue).trim());
            }
            return OBJECT_MAPPER.writeValueAsString((Object)node);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get extra info from advance info map", (Throwable)ex);
            return null;
        }
    }

    public static String getExtInfoFromAllInfo(ConfigAllInfo configAllInfo) {
        ObjectNode node = OBJECT_MAPPER.createObjectNode();
        if (StringUtils.isNotBlank((String)configAllInfo.getType())) {
            node.put("type", configAllInfo.getType());
        }
        if (StringUtils.isNotBlank((String)configAllInfo.getConfigTags())) {
            node.put("config_tags", configAllInfo.getConfigTags());
        }
        if (StringUtils.isNotBlank((String)configAllInfo.getEffect())) {
            node.put("effect", configAllInfo.getEffect());
        }
        if (StringUtils.isNotBlank((String)configAllInfo.getCreateUser())) {
            node.put("src_user", configAllInfo.getCreateUser());
        }
        if (StringUtils.isNotBlank((String)configAllInfo.getDesc())) {
            node.put("c_desc", configAllInfo.getDesc());
        }
        if (StringUtils.isNotBlank((String)configAllInfo.getUse())) {
            node.put("c_use", configAllInfo.getUse());
        }
        if (StringUtils.isNotBlank((String)configAllInfo.getSchema())) {
            node.put("c_schema", configAllInfo.getSchema());
        }
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)node);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get extra info from all config info", (Throwable)ex);
            return null;
        }
    }

    public static String getExtInfoFromGrayInfo(String grayName, String grayRuleTmp, String oldSrcUser) {
        ObjectNode node = OBJECT_MAPPER.createObjectNode();
        ObjectNode grayRuleNode = OBJECT_MAPPER.createObjectNode();
        if (StringUtils.isNotBlank((String)grayName)) {
            node.put("gray_name", grayName);
        }
        if (StringUtils.isNotBlank((String)oldSrcUser)) {
            node.put("src_user", oldSrcUser);
        }
        if (StringUtils.isNotBlank((String)grayRuleTmp)) {
            try {
                JsonNode parsedGrayRuleNode = OBJECT_MAPPER.readTree(grayRuleTmp);
                if (parsedGrayRuleNode.has("type")) {
                    grayRuleNode.put("type", parsedGrayRuleNode.get("type").asText());
                }
                if (parsedGrayRuleNode.has("expr")) {
                    grayRuleNode.put("expr", parsedGrayRuleNode.get("expr").asText());
                }
                if (parsedGrayRuleNode.has("version")) {
                    grayRuleNode.put("version", parsedGrayRuleNode.get("version").asText());
                }
                if (parsedGrayRuleNode.has("priority")) {
                    grayRuleNode.put("priority", parsedGrayRuleNode.get("priority").asText());
                }
                node.put("gray_rule", grayRuleNode.toString());
            }
            catch (Exception ex) {
                LOGGER.error("Failed to parse gray rule as json", (Throwable)ex);
                return null;
            }
        }
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)node);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to serialize extra info from gray info", (Throwable)ex);
            return null;
        }
    }

    static {
        EXTRA_INFO_KEYS_MAPPING.put("type", "type");
        EXTRA_INFO_KEYS_MAPPING.put("config_tags", "config_tags");
        EXTRA_INFO_KEYS_MAPPING.put("src_user", "src_user");
        EXTRA_INFO_KEYS_MAPPING.put("desc", "c_desc");
        EXTRA_INFO_KEYS_MAPPING.put("use", "c_use");
        EXTRA_INFO_KEYS_MAPPING.put("effect", "effect");
        EXTRA_INFO_KEYS_MAPPING.put("schema", "c_schema");
    }
}

