/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoTagWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoTagMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoTagPersistServiceImpl")
public class EmbeddedConfigInfoTagPersistServiceImpl
implements ConfigInfoTagPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedConfigInfoTagPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfo4TagState(String dataId, String group, String tenant, String tag) {
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        String sql = configInfoTagMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id"));
        return (ConfigInfoStateWrapper)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp, tagTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
    }

    private ConfigOperateResult getTagOperateResult(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)tenant);
        ConfigInfoStateWrapper configInfo4Tag = this.findConfigInfo4TagState(dataId, group, tenantTmp, tag);
        if (configInfo4Tag == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfo4Tag.getId(), configInfo4Tag.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult addConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            String sql = configInfoTagMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "tag_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_create", "gmt_modified"));
            Timestamp time = new Timestamp(System.currentTimeMillis());
            Object[] args = new Object[]{configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp, appNameTmp, configInfo.getContent(), md5, srcIp, srcUser, time, time};
            EmbeddedStorageContextUtils.onModifyConfigTagInfo(configInfo, tagTmp, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
            this.databaseOperate.blockUpdate();
            ConfigOperateResult configOperateResult = this.getTagOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public ConfigOperateResult insertOrUpdateTag(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        if (this.findConfigInfo4TagState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), tag) == null) {
            return this.addConfigInfo4Tag(configInfo, tag, srcIp, srcUser);
        }
        return this.updateConfigInfo4Tag(configInfo, tag, srcIp, srcUser);
    }

    @Override
    public ConfigOperateResult insertOrUpdateTagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        if (this.findConfigInfo4TagState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), tag) == null) {
            return this.addConfigInfo4Tag(configInfo, tag, srcIp, srcUser);
        }
        return this.updateConfigInfo4TagCas(configInfo, tag, srcIp, srcUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfoTag(String dataId, String group, String tenant, String tag, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag;
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sql = configInfoTagMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "tag_id"));
        Object[] args = new Object[]{dataId, group, tenantTmp, tagTmp};
        EmbeddedStorageContextUtils.onDeleteConfigTagInfo(tenantTmp, group, dataId, tagTmp, srcIp);
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfo4Tag(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String sql = configInfoTagMapper.update(Arrays.asList("content", "md5", "src_ip", "src_user", "gmt_modified", "app_name"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id"));
            Object[] args = new Object[]{configInfo.getContent(), md5, srcIp, srcUser, time, appNameTmp, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp};
            EmbeddedStorageContextUtils.onModifyConfigTagInfo(configInfo, tagTmp, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
            this.databaseOperate.blockUpdate();
            ConfigOperateResult configOperateResult = this.getTagOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfo4TagCas(ConfigInfo configInfo, String tag, String srcIp, String srcUser) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        configInfo.setTenant(tenantTmp);
        try {
            String md5 = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
            ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
            Timestamp time = new Timestamp(System.currentTimeMillis());
            MapperContext context = new MapperContext();
            context.putUpdateParameter("content", (Object)configInfo.getContent());
            context.putUpdateParameter("md5", (Object)md5);
            context.putUpdateParameter("srcIp", (Object)srcIp);
            context.putUpdateParameter("srcUser", (Object)srcUser);
            context.putUpdateParameter("gmtModified", (Object)time);
            context.putUpdateParameter("app_name", (Object)appNameTmp);
            context.putWhereParameter("dataId", (Object)configInfo.getDataId());
            context.putWhereParameter("groupId", (Object)configInfo.getGroup());
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            context.putWhereParameter("tagId", (Object)tagTmp);
            context.putWhereParameter("md5", (Object)configInfo.getMd5());
            MapperResult mapperResult = configInfoTagMapper.updateConfigInfo4TagCas(context);
            EmbeddedStorageContextUtils.onModifyConfigTagInfo(configInfo, tagTmp, srcIp, time);
            EmbeddedStorageContextHolder.addSqlContext((String)mapperResult.getSql(), (Object[])mapperResult.getParamList().toArray());
            Boolean success = this.databaseOperate.blockUpdate();
            if (success.booleanValue()) {
                ConfigOperateResult configOperateResult = this.getTagOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp, tagTmp);
                return configOperateResult;
            }
            ConfigOperateResult configOperateResult = new ConfigOperateResult(false);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public ConfigInfoTagWrapper findConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String tagTmp = StringUtils.isBlank((CharSequence)tag) ? "" : tag.trim();
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sql = configInfoTagMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "tag_id", "app_name", "content", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "tag_id"));
        return (ConfigInfoTagWrapper)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp, tagTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
    }

    @Override
    public int configInfoTagCount() {
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sql = configInfoTagMapper.count(null);
        Integer result = (Integer)this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoBetaCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoTagWrapper> findAllConfigInfoTagForDumpAll(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sqlCountRows = configInfoTagMapper.count(null);
        MapperResult sqlFetchRows = configInfoTagMapper.findAllConfigInfoTagForDumpAllFetchRows(new MapperContext(startRow, pageSize));
        PaginationHelper helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows.getSql(), sqlFetchRows.getParamList().toArray(), pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_TAG_WRAPPER_ROW_MAPPER);
    }

    @Override
    public List<String> findConfigInfoTags(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoTagMapper configInfoTagMapper = (ConfigInfoTagMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_tag");
        String sql = configInfoTagMapper.select(Collections.singletonList("tag_id"), Arrays.asList("data_id", "group_id", "tenant_id"));
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, group, tenantTmp}, String.class);
    }
}

