/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigFuzzyWatchSyncRequest;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.api.remote.request.ServerRequest;
import com.alibaba.nacos.common.task.BatchTaskCounter;
import com.alibaba.nacos.config.server.remote.FuzzyWatchSyncNotifyCallback;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RpcPushService;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

class FuzzyWatchSyncNotifyTask
implements Runnable {
    static final String CONFIG_FUZZY_WATCH_CONFIG_SYNC = "FUZZY_WATCH_CONFIG_SYNC_PUSH";
    static final String CONFIG_FUZZY_WATCH_CONFIG_SYNC_SUCCESS = "CONFIG_FUZZY_WATCH_CONFIG_SYNC_SUCCESS";
    static final String CONFIG_FUZZY_WATCH_CONFIG_SYNC_FAIL = "CONFIG_FUZZY_WATCH_CONFIG_SYNC_FAIL";
    final ConnectionManager connectionManager;
    final RpcPushService rpcPushService;
    ConfigFuzzyWatchSyncRequest notifyRequest;
    int maxRetryTimes;
    int tryTimes = 0;
    String connectionId;
    BatchTaskCounter batchTaskCounter;

    public FuzzyWatchSyncNotifyTask(ConnectionManager connectionManager, RpcPushService rpcPushService, ConfigFuzzyWatchSyncRequest notifyRequest, BatchTaskCounter batchTaskCounter, int maxRetryTimes, String connectionId) {
        this.connectionManager = connectionManager;
        this.rpcPushService = rpcPushService;
        this.notifyRequest = notifyRequest;
        this.batchTaskCounter = batchTaskCounter;
        this.maxRetryTimes = maxRetryTimes;
        this.connectionId = connectionId;
    }

    public boolean isOverTimes() {
        return this.maxRetryTimes > 0 && this.tryTimes >= this.maxRetryTimes;
    }

    @Override
    public void run() {
        if (this.isOverTimes()) {
            Loggers.REMOTE_PUSH.warn("Push callback retry failed over times. groupKeyPattern={}, clientId={}, will unregister client.", (Object)this.notifyRequest.getGroupKeyPattern(), (Object)this.connectionId);
            this.connectionManager.unregister(this.connectionId);
        } else if (this.connectionManager.getConnection(this.connectionId) != null) {
            ++this.tryTimes;
            TpsCheckRequest tpsCheckRequest = new TpsCheckRequest();
            tpsCheckRequest.setPointName(CONFIG_FUZZY_WATCH_CONFIG_SYNC);
            if (!ControlManagerCenter.getInstance().getTpsControlManager().check(tpsCheckRequest).isSuccess()) {
                this.scheduleSelf();
            } else {
                this.rpcPushService.pushWithCallback(this.connectionId, (ServerRequest)this.notifyRequest, (PushCallBack)new FuzzyWatchSyncNotifyCallback(this), (Executor)ConfigExecutor.getClientConfigNotifierServiceExecutor());
            }
        }
    }

    void scheduleSelf() {
        ConfigExecutor.scheduleClientConfigNotifier(this, (long)this.tryTimes * 2L, TimeUnit.SECONDS);
    }
}

