/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigPublishResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.exception.ConfigAlreadyExistsException;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.service.ConfigOperationService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import org.springframework.stereotype.Component;

@Component
public class ConfigPublishRequestHandler
extends RequestHandler<ConfigPublishRequest, ConfigPublishResponse> {
    private ConfigOperationService configOperationService;

    public ConfigPublishRequestHandler(ConfigOperationService configOperationService) {
        this.configOperationService = configOperationService;
    }

    @TpsControl(pointName="ConfigPublish")
    @Secured(action=ActionTypes.WRITE, signType="config")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    public ConfigPublishResponse handle(ConfigPublishRequest request, RequestMeta meta) throws NacosException {
        try {
            String dataId = request.getDataId();
            String group = request.getGroup();
            String content = request.getContent();
            boolean namespaceTransferred = NamespaceUtil.isNeedTransferNamespace((String)request.getTenant());
            String tenant = NamespaceUtil.processNamespaceParameter((String)request.getTenant());
            String srcIp = meta.getClientIp();
            String tag = request.getAdditionParam("tag");
            String appName = request.getAdditionParam("appName");
            String type = request.getAdditionParam("type");
            String srcUser = request.getAdditionParam("src_user");
            String encryptedDataKey = request.getAdditionParam("encryptedDataKey");
            ParamUtils.checkParam(dataId, group, "datumId", content);
            ParamUtils.checkParam(tag);
            ConfigForm configForm = new ConfigForm();
            configForm.setDataId(dataId);
            configForm.setGroup(group);
            configForm.setNamespaceId(tenant);
            configForm.setContent(content);
            configForm.setTag(tag);
            configForm.setAppName(appName);
            configForm.setSrcUser(srcUser);
            configForm.setConfigTags(request.getAdditionParam("config_tags"));
            configForm.setDesc(request.getAdditionParam("desc"));
            configForm.setUse(request.getAdditionParam("use"));
            configForm.setEffect(request.getAdditionParam("effect"));
            configForm.setType(type);
            configForm.setSchema(request.getAdditionParam("schema"));
            if (!ConfigType.isValidType((String)type).booleanValue()) {
                configForm.setType(ConfigType.getDefaultType().getType());
            }
            ConfigRequestInfo configRequestInfo = new ConfigRequestInfo();
            configRequestInfo.setSrcIp(srcIp);
            configRequestInfo.setSrcType("rpc");
            configRequestInfo.setRequestIpApp((String)meta.getLabels().get("AppName"));
            configRequestInfo.setBetaIps(request.getAdditionParam("betaIps"));
            configRequestInfo.setCasMd5(request.getCasMd5());
            configRequestInfo.setNamespaceTransferred(namespaceTransferred);
            String encryptedDataKeyFinal = null;
            if (StringUtils.isNotBlank((String)encryptedDataKey)) {
                encryptedDataKeyFinal = encryptedDataKey;
            } else {
                Pair pair = EncryptionHandler.encryptHandler((String)dataId, (String)content);
                content = (String)pair.getSecond();
                encryptedDataKeyFinal = (String)pair.getFirst();
                configForm.setContent(content);
            }
            try {
                this.configOperationService.publishConfig(configForm, configRequestInfo, encryptedDataKeyFinal);
                return ConfigPublishResponse.buildSuccessResponse();
            }
            catch (NacosApiException | ConfigAlreadyExistsException ex) {
                return ConfigPublishResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)ex.getErrMsg());
            }
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.error("[ConfigPublishRequestHandler] publish config error ,request ={}", (Object)request, (Object)e);
            return ConfigPublishResponse.buildFailResponse((int)(e instanceof NacosException ? ((NacosException)((Object)e)).getErrCode() : ResponseCode.FAIL.getCode()), (String)e.getMessage());
        }
    }
}

