/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.monitor;

import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;

public class ResponseMonitor {
    private static AtomicLong[] getConfigCountDetail = new AtomicLong[8];
    private static AtomicLong getConfigCount = new AtomicLong();
    private static final int MS_50 = 50;
    private static final int MS_100 = 100;
    private static final int MS_200 = 200;
    private static final int MS_500 = 500;
    private static final int MS_1000 = 1000;
    private static final int MS_2000 = 2000;
    private static final int MS_3000 = 3000;

    public static void refresh() {
        for (int i = 0; i < getConfigCountDetail.length; ++i) {
            ResponseMonitor.getConfigCountDetail[i] = new AtomicLong();
        }
    }

    public static void addConfigTime(long time) {
        getConfigCount.incrementAndGet();
        if (time < 50L) {
            getConfigCountDetail[0].incrementAndGet();
        } else if (time < 100L) {
            getConfigCountDetail[1].incrementAndGet();
        } else if (time < 200L) {
            getConfigCountDetail[2].incrementAndGet();
        } else if (time < 500L) {
            getConfigCountDetail[3].incrementAndGet();
        } else if (time < 1000L) {
            getConfigCountDetail[4].incrementAndGet();
        } else if (time < 2000L) {
            getConfigCountDetail[5].incrementAndGet();
        } else if (time < 3000L) {
            getConfigCountDetail[6].incrementAndGet();
        } else {
            getConfigCountDetail[7].incrementAndGet();
        }
    }

    public static String getStringForPrint() {
        DecimalFormat df = new DecimalFormat("##.0");
        StringBuilder s = new StringBuilder("getConfig monitor:\r\n");
        s.append("0-50ms:" + df.format(getConfigCountDetail[0].getAndSet(0L) * 100L / getConfigCount.get())).append("%\r\n");
        s.append("100-200ms:" + df.format(getConfigCountDetail[2].getAndSet(0L) * 100L / getConfigCount.get())).append("%\r\n");
        s.append("200-500ms:" + df.format(getConfigCountDetail[3].getAndSet(0L) * 100L / getConfigCount.get())).append("%\r\n");
        s.append("500-1000ms:" + df.format(getConfigCountDetail[4].getAndSet(0L) * 100L / getConfigCount.get())).append("%\r\n");
        s.append("1000-2000ms:" + df.format(getConfigCountDetail[5].getAndSet(0L) * 100L / getConfigCount.get())).append("%\r\n");
        s.append("2000-3000ms:" + df.format(getConfigCountDetail[6].getAndSet(0L) * 100L / getConfigCount.get())).append("%\r\n");
        s.append("3000\u4ee5\u4e0ams:" + df.format(getConfigCountDetail[7].getAndSet(0L) * 100L / getConfigCount.getAndSet(0L))).append("%\r\n");
        return s.toString();
    }

    static {
        ResponseMonitor.refresh();
    }
}

