/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model.gray;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.config.server.model.gray.ConfigGrayPersistInfo;
import com.alibaba.nacos.config.server.model.gray.GrayRule;
import com.google.gson.Gson;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GrayRuleManager {
    private static final Map<String, Class<?>> GRAY_RULE_MAP = new ConcurrentHashMap(8);
    public static final String SPLIT = "_";

    public static Class<?> getClassByTypeAndVersion(String type, String version) {
        return GRAY_RULE_MAP.get(type + SPLIT + version);
    }

    public static GrayRule constructGrayRule(ConfigGrayPersistInfo configGrayPersistInfo) {
        Class<?> classByTypeAndVersion = GrayRuleManager.getClassByTypeAndVersion(configGrayPersistInfo.getType(), configGrayPersistInfo.getVersion());
        if (classByTypeAndVersion == null) {
            return null;
        }
        try {
            Constructor<?> declaredConstructor = classByTypeAndVersion.getDeclaredConstructor(String.class, Integer.TYPE);
            declaredConstructor.setAccessible(true);
            return (GrayRule)declaredConstructor.newInstance(configGrayPersistInfo.getExpr(), configGrayPersistInfo.getPriority());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("construct gray rule failed with type[%s], version[%s].", configGrayPersistInfo.getType(), configGrayPersistInfo.getVersion()), e);
        }
    }

    public static ConfigGrayPersistInfo constructConfigGrayPersistInfo(GrayRule grayRule) {
        return new ConfigGrayPersistInfo(grayRule.getType(), grayRule.getVersion(), grayRule.getRawGrayRuleExp(), grayRule.getPriority());
    }

    public static ConfigGrayPersistInfo deserializeConfigGrayPersistInfo(String grayRuleRawStringFromDb) {
        return (ConfigGrayPersistInfo)new Gson().fromJson(grayRuleRawStringFromDb, ConfigGrayPersistInfo.class);
    }

    public static String serializeConfigGrayPersistInfo(ConfigGrayPersistInfo configGrayPersistInfo) {
        return new Gson().toJson((Object)configGrayPersistInfo);
    }

    static {
        Collection grayRuleCollection = NacosServiceLoader.load(GrayRule.class);
        for (GrayRule grayRule : grayRuleCollection) {
            GRAY_RULE_MAP.put(grayRule.getType() + SPLIT + grayRule.getVersion(), grayRule.getClass());
        }
    }
}

