/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.model;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigCache;
import com.alibaba.nacos.config.server.model.ConfigCacheFactory;
import com.alibaba.nacos.config.server.model.ConfigCacheGray;
import com.alibaba.nacos.config.server.model.NacosConfigCacheFactory;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCacheFactoryDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCacheFactoryDelegate.class);
    private static final ConfigCacheFactoryDelegate INSTANCE = new ConfigCacheFactoryDelegate();
    private String configCacheFactoryType = EnvUtil.getProperty((String)"nacos.config.cache.type", (String)"nacos");
    private ConfigCacheFactory configCacheFactory = null;

    private ConfigCacheFactoryDelegate() {
        Collection configCacheFactories = NacosServiceLoader.load(ConfigCacheFactory.class);
        for (ConfigCacheFactory each : configCacheFactories) {
            if (StringUtils.isEmpty((String)each.getName())) {
                LOGGER.warn("[ConfigCacheFactoryDelegate] Load ConfigCacheFactory({}) ConfigFactroyName (null/empty) fail. Please add ConfigFactoryName to resolve", (Object)each.getClass().getName());
                continue;
            }
            LOGGER.info("[ConfigCacheFactoryDelegate] Load ConfigCacheFactory({}) ConfigCacheFactoryName({}) successfully. ", (Object)each.getClass().getName(), (Object)each.getName());
            if (!StringUtils.equals((String)this.configCacheFactoryType, (String)each.getName())) continue;
            LOGGER.info("[ConfigCacheFactoryDelegate] Matched ConfigCacheFactory found,set configCacheFactory={}", (Object)each.getClass().getName());
            this.configCacheFactory = each;
        }
        if (this.configCacheFactory == null) {
            LOGGER.info("[ConfigCacheFactoryDelegate] Matched ConfigCacheFactory not found, Load Default NacosConfigCacheFactory successfully.");
            this.configCacheFactory = new NacosConfigCacheFactory();
        }
    }

    public static ConfigCacheFactoryDelegate getInstance() {
        return INSTANCE;
    }

    public ConfigCache createConfigCache() {
        return this.configCacheFactory.createConfigCache();
    }

    public ConfigCache createConfigCache(String md5, long lastModifiedTs) {
        ConfigCache configCache = this.createConfigCache();
        configCache.setMd5(md5);
        configCache.setLastModifiedTs(lastModifiedTs);
        return configCache;
    }

    public ConfigCacheGray createConfigCacheGray() {
        return this.configCacheFactory.createConfigCacheGray();
    }

    public ConfigCacheGray createConfigCacheGray(String grayName) {
        ConfigCacheGray configCacheGray = this.configCacheFactory.createConfigCacheGray();
        configCacheGray.setGrayName(grayName);
        return configCacheGray;
    }
}

