/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v3;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.model.form.UpdateCapacityForm;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.capacity.CapacityService;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/admin/cs/capacity"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class CapacityControllerV3 {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapacityControllerV3.class);
    private final CapacityService capacityService;

    public CapacityControllerV3(CapacityService capacityService) {
        this.capacityService = capacityService;
    }

    @GetMapping
    @Secured(resource="/v3/admin/cs/capacity", action=ActionTypes.READ, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Capacity> getCapacity(@RequestParam(required=false) String groupName, @RequestParam(required=false) String namespaceId) throws NacosApiException {
        if (StringUtils.isBlank((CharSequence)groupName) && StringUtils.isBlank((CharSequence)namespaceId)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "At least one of the parameters (groupName or namespaceId) must be provided");
        }
        try {
            Capacity capacity = this.capacityService.getCapacityWithDefault(groupName, namespaceId);
            if (capacity == null) {
                LOGGER.warn("[getCapacity] capacity not exist\uff0cneed init groupName: {}, namespaceId: {}", (Object)groupName, (Object)namespaceId);
                this.capacityService.initCapacity(groupName, namespaceId);
                capacity = this.capacityService.getCapacityWithDefault(groupName, namespaceId);
            }
            return Result.success((Object)capacity);
        }
        catch (Exception e) {
            LOGGER.error("[getCapacity] Failed to fetch capacity for groupName: {}, namespaceId: {}", new Object[]{groupName, namespaceId, e});
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)e.getMessage(), null);
        }
    }

    @PostMapping
    @Secured(resource="/v3/admin/cs/capacity", action=ActionTypes.WRITE, signType="config", apiType=ApiType.ADMIN_API)
    public Result<Boolean> updateCapacity(UpdateCapacityForm updateCapacityForm) throws NacosApiException {
        updateCapacityForm.checkNamespaceIdAndGroupName(this.capacityService);
        updateCapacityForm.validate();
        String groupName = updateCapacityForm.getGroupName();
        String namespaceId = updateCapacityForm.getNamespaceId();
        Integer quota = updateCapacityForm.getQuota();
        Integer maxSize = updateCapacityForm.getMaxSize();
        Integer maxAggrCount = updateCapacityForm.getMaxAggrCount();
        Integer maxAggrSize = updateCapacityForm.getMaxAggrSize();
        try {
            boolean isSuccess = this.capacityService.insertOrUpdateCapacity(groupName, namespaceId, quota, maxSize, maxAggrCount, maxAggrSize);
            if (isSuccess) {
                return Result.success((Object)true);
            }
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)String.format("Failed to update the capacity for groupName: %s, namespaceId: %s", groupName, namespaceId), null);
        }
        catch (Exception e) {
            LOGGER.error("[updateCapacity] Failed to update the capacity for groupName: {}, namespaceId: {}", new Object[]{groupName, namespaceId, e});
            return Result.failure((Integer)ErrorCode.SERVER_ERROR.getCode(), (String)e.getMessage(), null);
        }
    }
}

