/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.CounterMode;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.config.server.service.capacity.CapacityService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import java.nio.charset.StandardCharsets;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CapacityManagementAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapacityManagementAspect.class);
    private static final String PUBLISH_CONFIG = "execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.publishConfig(..))";
    private static final String DELETE_CONFIG = "execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.deleteConfig(..))";
    private final CapacityService capacityService;
    private final ConfigInfoPersistService configInfoPersistService;

    public CapacityManagementAspect(ConfigInfoPersistService configInfoPersistService, CapacityService capacityService) {
        this.configInfoPersistService = configInfoPersistService;
        this.capacityService = capacityService;
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.publishConfig(..))")
    public Object aroundPublishConfig(ProceedingJoinPoint pjp) throws Throwable {
        if (!PropertyUtil.isManageCapacity()) {
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        ConfigForm configForm = (ConfigForm)args[0];
        ConfigRequestInfo configRequestInfo = (ConfigRequestInfo)args[1];
        String dataId = configForm.getDataId();
        String group = configForm.getGroup();
        String namespaceId = configForm.getNamespaceId();
        String content = configForm.getContent();
        String betaIps = configRequestInfo.getBetaIps();
        String tag = configForm.getTag();
        LOGGER.info("[CapacityManagement] Intercepting publishConfig operation for dataId: {}, group: {}, namespaceId: {}", new Object[]{dataId, group, namespaceId});
        if (StringUtils.isBlank((CharSequence)betaIps) && StringUtils.isBlank((CharSequence)tag) && StringUtils.isBlank((CharSequence)configForm.getGrayName())) {
            if (this.configInfoPersistService.findConfigInfo(dataId, group, namespaceId) == null) {
                return this.do4Insert(pjp, group, namespaceId, content);
            }
            return this.do4Update(pjp, dataId, group, namespaceId, content);
        }
        return pjp.proceed();
    }

    private Object do4Update(ProceedingJoinPoint pjp, String dataId, String group, String namespaceId, String content) throws Throwable {
        if (!PropertyUtil.isCapacityLimitCheck()) {
            return pjp.proceed();
        }
        try {
            boolean hasTenant = StringUtils.isNotBlank((String)namespaceId);
            Capacity capacity = this.getCapacity(group, namespaceId, hasTenant);
            if (this.isSizeLimited(group, namespaceId, this.getCurrentSize(content), hasTenant, false, capacity)) {
                throw new NacosException(ErrorCode.OVER_MAX_SIZE.getCode().intValue(), String.format("Configuration content size limit exceeded [group=%s, namespaceId=%s].", group, namespaceId));
            }
        }
        catch (Exception e) {
            LOGGER.error("[CapacityManagement] Error during update operation for dataId: {}, group: {}, namespaceId: {}", new Object[]{dataId, group, namespaceId, e});
            throw e;
        }
        return pjp.proceed();
    }

    private Object do4Insert(ProceedingJoinPoint pjp, String group, String namespaceId, String content) throws Throwable {
        LOGGER.info("[CapacityManagement] Handling insert operation for group: {}, namespaceId: {}", (Object)group, (Object)namespaceId);
        CounterMode counterMode = CounterMode.INCREMENT;
        boolean hasTenant = StringUtils.isNotBlank((String)namespaceId);
        if (PropertyUtil.isCapacityLimitCheck()) {
            ErrorCode errorCode;
            LimitType limitType = this.getLimitType(counterMode, group, namespaceId, content, hasTenant);
            if (limitType != null && (errorCode = ErrorCode.getErrorCode((String)limitType.name())) != null) {
                throw new NacosException(errorCode.getCode().intValue(), String.format("Configuration limit exceeded [group=%s, namespaceId=%s].", group, namespaceId));
            }
        } else {
            this.insertOrUpdateUsage(group, namespaceId, counterMode, hasTenant);
        }
        return this.getResult(pjp, group, namespaceId, counterMode, hasTenant);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.service.ConfigOperationService.deleteConfig(..))")
    public Object aroundDeleteConfig(ProceedingJoinPoint pjp) throws Throwable {
        if (!PropertyUtil.isManageCapacity()) {
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        String dataId = (String)args[0];
        String group = (String)args[1];
        String namespaceId = (String)args[2];
        String grayName = (String)args[3];
        LOGGER.info("[CapacityManagement] Intercepting deleteConfig operation for dataId: {}, group: {}, namespaceId: {}", new Object[]{dataId, group, namespaceId});
        if (StringUtils.isNotBlank((String)grayName)) {
            return pjp.proceed();
        }
        ConfigInfoWrapper configInfo = this.configInfoPersistService.findConfigInfo(dataId, group, namespaceId);
        if (configInfo == null) {
            return pjp.proceed();
        }
        return this.do4Delete(pjp, group, namespaceId, configInfo);
    }

    private Object do4Delete(ProceedingJoinPoint pjp, String group, String namespaceId, ConfigInfo configInfo) throws Throwable {
        boolean hasTenant = StringUtils.isNotBlank((String)namespaceId);
        if (configInfo == null) {
            this.correctUsage(group, namespaceId, hasTenant);
            return pjp.proceed();
        }
        CounterMode counterMode = CounterMode.DECREMENT;
        this.insertOrUpdateUsage(group, namespaceId, counterMode, hasTenant);
        return this.getResult(pjp, group, namespaceId, counterMode, hasTenant);
    }

    private void correctUsage(String group, String namespaceId, boolean hasTenant) {
        try {
            if (hasTenant) {
                LOGGER.info("[capacityManagement] correct usage, namespaceId: {}", (Object)namespaceId);
                this.capacityService.correctTenantUsage(namespaceId);
            } else {
                LOGGER.info("[capacityManagement] correct usage, group: {}", (Object)group);
                this.capacityService.correctGroupUsage(group);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] correctUsage ", (Throwable)e);
        }
    }

    private Object getResult(ProceedingJoinPoint pjp, String group, String namespaceId, CounterMode counterMode, boolean hasTenant) throws Throwable {
        try {
            Boolean result = (Boolean)pjp.proceed();
            if (!result.booleanValue()) {
                this.rollbackUsage(counterMode, group, namespaceId, hasTenant);
            }
            return result;
        }
        catch (Throwable throwable) {
            LOGGER.warn("[capacityManagement] inner operation throw exception, rollback, group: {}, namespaceId: {}", new Object[]{group, namespaceId, throwable});
            this.rollbackUsage(counterMode, group, namespaceId, hasTenant);
            throw throwable;
        }
    }

    private void insertOrUpdateUsage(String group, String namespaceId, CounterMode counterMode, boolean hasTenant) {
        try {
            this.capacityService.insertAndUpdateClusterUsage(counterMode, true);
            if (hasTenant) {
                this.capacityService.insertAndUpdateTenantUsage(counterMode, namespaceId, true);
            } else {
                this.capacityService.insertAndUpdateGroupUsage(counterMode, group, true);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] insertOrUpdateUsage ", (Throwable)e);
        }
    }

    private LimitType getLimitType(CounterMode counterMode, String group, String namespaceId, String content, boolean hasTenant) {
        try {
            boolean clusterLimited;
            boolean bl = clusterLimited = !this.capacityService.insertAndUpdateClusterUsage(counterMode, false);
            if (clusterLimited) {
                LOGGER.warn("[capacityManagement] cluster capacity reaches quota.");
                return LimitType.OVER_CLUSTER_QUOTA;
            }
            if (content == null) {
                return null;
            }
            int currentSize = this.getCurrentSize(content);
            LimitType limitType = this.getGroupOrTenantLimitType(counterMode, group, namespaceId, currentSize, hasTenant);
            if (limitType != null) {
                this.rollbackClusterUsage(counterMode);
                return limitType;
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] isLimited ", (Throwable)e);
        }
        return null;
    }

    private int getCurrentSize(String content) {
        try {
            return content.getBytes(StandardCharsets.UTF_8).length;
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] getCurrentSize ", (Throwable)e);
            return 0;
        }
    }

    private LimitType getGroupOrTenantLimitType(CounterMode counterMode, String group, String namespaceId, int currentSize, boolean hasTenant) {
        boolean updateSuccess;
        if (group == null) {
            return null;
        }
        Capacity capacity = this.getCapacity(group, namespaceId, hasTenant);
        if (this.isSizeLimited(group, namespaceId, currentSize, hasTenant, false, capacity)) {
            return LimitType.OVER_MAX_SIZE;
        }
        if (capacity == null) {
            this.insertCapacity(group, namespaceId, hasTenant);
        }
        if (updateSuccess = this.isUpdateSuccess(counterMode, group, namespaceId, hasTenant)) {
            return null;
        }
        if (hasTenant) {
            return LimitType.OVER_TENANT_QUOTA;
        }
        return LimitType.OVER_GROUP_QUOTA;
    }

    private boolean isUpdateSuccess(CounterMode counterMode, String group, String namespaceId, boolean hasTenant) {
        boolean updateSuccess;
        if (hasTenant) {
            updateSuccess = this.capacityService.updateTenantUsage(counterMode, namespaceId);
            if (!updateSuccess) {
                LOGGER.warn("[capacityManagement] namespaceId capacity reaches quota, namespaceId: {}", (Object)namespaceId);
            }
        } else {
            updateSuccess = this.capacityService.updateGroupUsage(counterMode, group);
            if (!updateSuccess) {
                LOGGER.warn("[capacityManagement] group capacity reaches quota, group: {}", (Object)group);
            }
        }
        return updateSuccess;
    }

    private void insertCapacity(String group, String namespaceId, boolean hasTenant) {
        if (hasTenant) {
            this.capacityService.initTenantCapacity(namespaceId);
        } else {
            this.capacityService.initGroupCapacity(group);
        }
    }

    private Capacity getCapacity(String group, String namespaceId, boolean hasTenant) {
        Capacity capacity = hasTenant ? this.capacityService.getTenantCapacity(namespaceId) : this.capacityService.getGroupCapacity(group);
        return capacity;
    }

    private boolean isSizeLimited(String group, String namespaceId, int currentSize, boolean hasTenant, boolean isAggr, Capacity capacity) {
        int defaultMaxSize = this.getDefaultMaxSize(isAggr);
        if (capacity != null) {
            Integer maxSize = this.getMaxSize(isAggr, capacity);
            if (maxSize == 0) {
                return this.isOverSize(group, namespaceId, currentSize, defaultMaxSize, hasTenant);
            }
            return this.isOverSize(group, namespaceId, currentSize, maxSize, hasTenant);
        }
        return this.isOverSize(group, namespaceId, currentSize, defaultMaxSize, hasTenant);
    }

    private Integer getMaxSize(boolean isAggr, Capacity capacity) {
        if (isAggr) {
            return capacity.getMaxAggrSize();
        }
        return capacity.getMaxSize();
    }

    private int getDefaultMaxSize(boolean isAggr) {
        if (isAggr) {
            return PropertyUtil.getDefaultMaxAggrSize();
        }
        return PropertyUtil.getDefaultMaxSize();
    }

    private boolean isOverSize(String group, String namespaceId, int currentSize, int maxSize, boolean hasTenant) {
        if (currentSize > maxSize) {
            if (hasTenant) {
                LOGGER.warn("[capacityManagement] namespaceId content is over maxSize, namespaceId: {}, maxSize: {}, currentSize: {}", new Object[]{namespaceId, maxSize, currentSize});
            } else {
                LOGGER.warn("[capacityManagement] group content is over maxSize, group: {}, maxSize: {}, currentSize: {}", new Object[]{group, maxSize, currentSize});
            }
            return true;
        }
        return false;
    }

    private void rollbackUsage(CounterMode counterMode, String group, String namespaceId, boolean hasTenant) {
        try {
            this.rollbackClusterUsage(counterMode);
            if (hasTenant) {
                this.capacityService.updateTenantUsage(counterMode.reverse(), namespaceId);
            } else {
                this.capacityService.updateGroupUsage(counterMode.reverse(), group);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] rollback ", (Throwable)e);
        }
    }

    private void rollbackClusterUsage(CounterMode counterMode) {
        try {
            if (!this.capacityService.updateClusterUsage(counterMode.reverse())) {
                LOGGER.error("[capacityManagement] cluster usage rollback fail counterMode: {}", (Object)counterMode);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] rollback ", (Throwable)e);
        }
    }

    public static enum LimitType {
        OVER_CLUSTER_QUOTA("Exceeded the maximum number of configurations in the cluster", 429),
        OVER_GROUP_QUOTA("Exceeded the maximum number of configurations in this group", 429),
        OVER_TENANT_QUOTA("Exceeded the maximum number of configurations for this namespaceId", 429),
        OVER_MAX_SIZE("Exceeded the maximum size limit of the configuration content", 429);

        public final String description;
        public final int status;

        private LimitType(String description, int status) {
            this.description = description;
            this.status = status;
        }
    }
}

