/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc.redo;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.naming.cache.NamingFuzzyWatchServiceListHolder;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.redo.RedoScheduledTask;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.BatchInstanceRedoData;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.InstanceRedoData;
import com.alibaba.nacos.client.naming.remote.gprc.redo.data.SubscriberRedoData;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NamingGrpcRedoService
implements ConnectionEventListener {
    private static final String REDO_THREAD_NAME = "com.alibaba.nacos.client.naming.grpc.redo";
    private int redoThreadCount;
    private long redoDelayTime;
    private final ConcurrentMap<String, InstanceRedoData> registeredInstances = new ConcurrentHashMap<String, InstanceRedoData>();
    private final ConcurrentMap<String, SubscriberRedoData> subscribes = new ConcurrentHashMap<String, SubscriberRedoData>();
    private final NamingFuzzyWatchServiceListHolder namingFuzzyWatchServiceListHolder;
    private final ScheduledExecutorService redoExecutor;
    private volatile boolean connected = false;

    public NamingGrpcRedoService(NamingGrpcClientProxy clientProxy, NamingFuzzyWatchServiceListHolder namingFuzzyWatchServiceListHolder, NacosClientProperties properties) {
        this.setProperties(properties);
        this.namingFuzzyWatchServiceListHolder = namingFuzzyWatchServiceListHolder;
        this.redoExecutor = new ScheduledThreadPoolExecutor(this.redoThreadCount, (ThreadFactory)new NameThreadFactory(REDO_THREAD_NAME));
        this.redoExecutor.scheduleWithFixedDelay((Runnable)((Object)new RedoScheduledTask(clientProxy, this)), this.redoDelayTime, this.redoDelayTime, TimeUnit.MILLISECONDS);
    }

    private void setProperties(NacosClientProperties properties) {
        this.redoDelayTime = properties.getLong("redoDelayTime", Long.valueOf(3000L));
        this.redoThreadCount = properties.getInteger("redoDelayThreadCount", Integer.valueOf(1));
    }

    public ConcurrentMap<String, InstanceRedoData> getRegisteredInstances() {
        return this.registeredInstances;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void onConnected(Connection connection) {
        this.connected = true;
        LogUtils.NAMING_LOGGER.info("Grpc connection connect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisConnect(Connection connection) {
        this.connected = false;
        LogUtils.NAMING_LOGGER.warn("Grpc connection disconnect, mark to redo");
        Object object = this.registeredInstances;
        synchronized (object) {
            this.registeredInstances.values().forEach(instanceRedoData -> instanceRedoData.setRegistered(false));
        }
        object = this.subscribes;
        synchronized (object) {
            this.subscribes.values().forEach(subscriberRedoData -> subscriberRedoData.setRegistered(false));
        }
        object = this.namingFuzzyWatchServiceListHolder;
        synchronized (object) {
            this.namingFuzzyWatchServiceListHolder.resetConsistenceStatus();
        }
        LogUtils.NAMING_LOGGER.warn("mark to redo completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheInstanceForRedo(String serviceName, String groupName, Instance instance) {
        String key = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        InstanceRedoData redoData = InstanceRedoData.build(serviceName, groupName, instance);
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.registeredInstances;
        synchronized (concurrentMap) {
            this.registeredInstances.put(key, redoData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheInstanceForRedo(String serviceName, String groupName, List<Instance> instances) {
        String key = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        BatchInstanceRedoData redoData = BatchInstanceRedoData.build(serviceName, groupName, instances);
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.registeredInstances;
        synchronized (concurrentMap) {
            this.registeredInstances.put(key, redoData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceRegistered(String serviceName, String groupName) {
        String key = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.registeredInstances;
        synchronized (concurrentMap) {
            InstanceRedoData redoData = (InstanceRedoData)this.registeredInstances.get(key);
            if (null != redoData) {
                redoData.registered();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceDeregister(String serviceName, String groupName) {
        String key = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.registeredInstances;
        synchronized (concurrentMap) {
            InstanceRedoData redoData = (InstanceRedoData)this.registeredInstances.get(key);
            if (null != redoData) {
                redoData.setUnregistering(true);
                redoData.setExpectedRegistered(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanceDeregistered(String serviceName, String groupName) {
        String key = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.registeredInstances;
        synchronized (concurrentMap) {
            InstanceRedoData redoData = (InstanceRedoData)this.registeredInstances.get(key);
            if (null != redoData) {
                redoData.unregistered();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceForRedo(String serviceName, String groupName) {
        String key = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.registeredInstances;
        synchronized (concurrentMap) {
            InstanceRedoData redoData = (InstanceRedoData)this.registeredInstances.get(key);
            if (null != redoData && !redoData.isExpectedRegistered()) {
                this.registeredInstances.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InstanceRedoData> findInstanceRedoData() {
        HashSet<InstanceRedoData> result = new HashSet<InstanceRedoData>();
        ConcurrentMap<String, InstanceRedoData> concurrentMap = this.registeredInstances;
        synchronized (concurrentMap) {
            for (InstanceRedoData each : this.registeredInstances.values()) {
                if (!each.isNeedRedo()) continue;
                result.add(each);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheSubscriberForRedo(String serviceName, String groupName, String cluster) {
        String key = ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)serviceName, (String)groupName), (String)cluster);
        SubscriberRedoData redoData = SubscriberRedoData.build(serviceName, groupName, cluster);
        ConcurrentMap<String, SubscriberRedoData> concurrentMap = this.subscribes;
        synchronized (concurrentMap) {
            this.subscribes.put(key, redoData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscriberRegistered(String serviceName, String groupName, String cluster) {
        String key = ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)serviceName, (String)groupName), (String)cluster);
        ConcurrentMap<String, SubscriberRedoData> concurrentMap = this.subscribes;
        synchronized (concurrentMap) {
            SubscriberRedoData redoData = (SubscriberRedoData)this.subscribes.get(key);
            if (null != redoData) {
                redoData.setRegistered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscriberDeregister(String serviceName, String groupName, String cluster) {
        String key = ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)serviceName, (String)groupName), (String)cluster);
        ConcurrentMap<String, SubscriberRedoData> concurrentMap = this.subscribes;
        synchronized (concurrentMap) {
            SubscriberRedoData redoData = (SubscriberRedoData)this.subscribes.get(key);
            if (null != redoData) {
                redoData.setUnregistering(true);
                redoData.setExpectedRegistered(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscriberRegistered(String serviceName, String groupName, String cluster) {
        String key = ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)serviceName, (String)groupName), (String)cluster);
        ConcurrentMap<String, SubscriberRedoData> concurrentMap = this.subscribes;
        synchronized (concurrentMap) {
            SubscriberRedoData redoData = (SubscriberRedoData)this.subscribes.get(key);
            return null != redoData && redoData.isRegistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriberForRedo(String serviceName, String groupName, String cluster) {
        String key = ServiceInfo.getKey((String)NamingUtils.getGroupedName((String)serviceName, (String)groupName), (String)cluster);
        ConcurrentMap<String, SubscriberRedoData> concurrentMap = this.subscribes;
        synchronized (concurrentMap) {
            SubscriberRedoData redoData = (SubscriberRedoData)this.subscribes.get(key);
            if (null != redoData && !redoData.isExpectedRegistered()) {
                this.subscribes.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SubscriberRedoData> findSubscriberRedoData() {
        HashSet<SubscriberRedoData> result = new HashSet<SubscriberRedoData>();
        ConcurrentMap<String, SubscriberRedoData> concurrentMap = this.subscribes;
        synchronized (concurrentMap) {
            for (SubscriberRedoData each : this.subscribes.values()) {
                if (!each.isNeedRedo()) continue;
                result.add(each);
            }
        }
        return result;
    }

    public InstanceRedoData getRegisteredInstancesByKey(String combinedServiceName) {
        return (InstanceRedoData)this.registeredInstances.get(combinedServiceName);
    }

    public void shutdown() {
        LogUtils.NAMING_LOGGER.info("Shutdown grpc redo service executor " + this.redoExecutor);
        this.registeredInstances.clear();
        this.subscribes.clear();
        this.redoExecutor.shutdownNow();
    }
}

