/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.client.constant.Constants;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.naming.cache.NamingFuzzyWatchServiceListHolder;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.core.NamingServerListManager;
import com.alibaba.nacos.client.naming.core.ServiceInfoUpdateService;
import com.alibaba.nacos.client.naming.event.InstancesChangeNotifier;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class NamingClientProxyDelegate
implements NamingClientProxy {
    private final NamingServerListManager serverListManager;
    private final ServiceInfoUpdateService serviceInfoUpdateService;
    private final ServiceInfoHolder serviceInfoHolder;
    private final NamingHttpClientProxy httpClientProxy;
    private final NamingGrpcClientProxy grpcClientProxy;
    private final SecurityProxy securityProxy;
    private ScheduledExecutorService executorService;

    public NamingClientProxyDelegate(String namespace, ServiceInfoHolder serviceInfoHolder, NacosClientProperties properties, InstancesChangeNotifier changeNotifier, NamingFuzzyWatchServiceListHolder namingFuzzyWatchServiceListHolder) throws NacosException {
        this.serviceInfoUpdateService = new ServiceInfoUpdateService(properties, serviceInfoHolder, this, changeNotifier);
        this.serverListManager = new NamingServerListManager(properties, namespace);
        this.serverListManager.start();
        this.serviceInfoHolder = serviceInfoHolder;
        this.securityProxy = new SecurityProxy(this.serverListManager, NamingHttpClientManager.getInstance().getNacosRestTemplate());
        this.initSecurityProxy(properties);
        this.httpClientProxy = new NamingHttpClientProxy(namespace, this.securityProxy, this.serverListManager, properties);
        this.grpcClientProxy = new NamingGrpcClientProxy(namespace, this.securityProxy, (ServerListFactory)this.serverListManager, properties, serviceInfoHolder, namingFuzzyWatchServiceListHolder);
    }

    private void initSecurityProxy(NacosClientProperties properties) {
        this.executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.naming.security"));
        Properties nacosClientPropertiesView = properties.asProperties();
        this.securityProxy.login(nacosClientPropertiesView);
        this.executorService.scheduleWithFixedDelay(() -> this.securityProxy.login(nacosClientPropertiesView), 0L, Constants.Security.SECURITY_INFO_REFRESH_INTERVAL_MILLS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        this.getExecuteClientProxy(instance).registerService(serviceName, groupName, instance);
    }

    @Override
    public void batchRegisterService(String serviceName, String groupName, List<Instance> instances) throws NacosException {
        LogUtils.NAMING_LOGGER.info("batchRegisterInstance instances: {} ,serviceName: {} begin.", instances, (Object)serviceName);
        if (CollectionUtils.isEmpty(instances)) {
            LogUtils.NAMING_LOGGER.warn("batchRegisterInstance instances is Empty:{}", instances);
        }
        this.grpcClientProxy.batchRegisterService(serviceName, groupName, instances);
        LogUtils.NAMING_LOGGER.info("batchRegisterInstance instances: {} ,serviceName: {} finish.", instances, (Object)serviceName);
    }

    @Override
    public void batchDeregisterService(String serviceName, String groupName, List<Instance> instances) throws NacosException {
        LogUtils.NAMING_LOGGER.info("batch DeregisterInstance instances: {} ,serviceName: {} begin.", instances, (Object)serviceName);
        if (CollectionUtils.isEmpty(instances)) {
            LogUtils.NAMING_LOGGER.warn("batch DeregisterInstance instances is Empty:{}", instances);
        }
        this.grpcClientProxy.batchDeregisterService(serviceName, groupName, instances);
        LogUtils.NAMING_LOGGER.info("batch DeregisterInstance instances: {} ,serviceName: {} finish.", instances, (Object)serviceName);
    }

    @Override
    public void deregisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        this.getExecuteClientProxy(instance).deregisterService(serviceName, groupName, instance);
    }

    @Override
    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
    }

    @Override
    public ServiceInfo queryInstancesOfService(String serviceName, String groupName, String clusters, boolean healthyOnly) throws NacosException {
        return this.grpcClientProxy.queryInstancesOfService(serviceName, groupName, clusters, healthyOnly);
    }

    @Override
    public Service queryService(String serviceName, String groupName) throws NacosException {
        return null;
    }

    @Override
    public void createService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        return false;
    }

    @Override
    public void updateService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        return this.grpcClientProxy.getServiceList(pageNo, pageSize, groupName, selector);
    }

    @Override
    public ServiceInfo subscribe(String serviceName, String groupName, String clusters) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[SUBSCRIBE-SERVICE] service:{}, group:{}, clusters:{} ", new Object[]{serviceName, groupName, clusters});
        String serviceNameWithGroup = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        String serviceKey = ServiceInfo.getKey((String)serviceNameWithGroup, (String)clusters);
        this.serviceInfoUpdateService.scheduleUpdateIfAbsent(serviceName, groupName, clusters);
        ServiceInfo result = this.serviceInfoHolder.getServiceInfoMap().get(serviceKey);
        if (null == result || !this.isSubscribed(serviceName, groupName, clusters)) {
            result = this.grpcClientProxy.subscribe(serviceName, groupName, clusters);
        }
        this.serviceInfoHolder.processServiceInfo(result);
        return result;
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, String clusters) throws NacosException {
        LogUtils.NAMING_LOGGER.debug("[UNSUBSCRIBE-SERVICE] service:{}, group:{}, cluster:{} ", new Object[]{serviceName, groupName, clusters});
        this.serviceInfoUpdateService.stopUpdateIfContain(serviceName, groupName, clusters);
        this.grpcClientProxy.unsubscribe(serviceName, groupName, clusters);
    }

    @Override
    public boolean isSubscribed(String serviceName, String groupName, String clusters) throws NacosException {
        return this.grpcClientProxy.isSubscribed(serviceName, groupName, clusters);
    }

    @Override
    public boolean serverHealthy() {
        return this.grpcClientProxy.serverHealthy() || this.httpClientProxy.serverHealthy();
    }

    private NamingClientProxy getExecuteClientProxy(Instance instance) {
        if (instance.isEphemeral() || this.grpcClientProxy.isAbilitySupportedByServer(AbilityKey.SERVER_PERSISTENT_INSTANCE_BY_GRPC)) {
            return this.grpcClientProxy;
        }
        return this.httpClientProxy;
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        this.serviceInfoUpdateService.shutdown();
        this.serverListManager.shutdown();
        this.httpClientProxy.shutdown();
        this.grpcClientProxy.shutdown();
        this.securityProxy.shutdown();
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LogUtils.NAMING_LOGGER);
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

