/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.cache;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.event.InstancesDiff;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class InstancesDiffer {
    public InstancesDiff doDiff(ServiceInfo oldService, ServiceInfo newService) {
        String key;
        Instance host;
        InstancesDiff instancesDiff = new InstancesDiff();
        if (null == oldService) {
            LogUtils.NAMING_LOGGER.info("init new ips({}) service: {} -> {}", new Object[]{newService.ipCount(), newService.getKey(), JacksonUtils.toJson((Object)newService.getHosts())});
            instancesDiff.setAddedInstances(newService.getHosts());
            return instancesDiff;
        }
        if (oldService.getLastRefTime() > newService.getLastRefTime()) {
            LogUtils.NAMING_LOGGER.warn("out of date data received, old-t: {}, new-t: {}", (Object)oldService.getLastRefTime(), (Object)newService.getLastRefTime());
            return instancesDiff;
        }
        HashMap<String, Instance> oldHostMap = new HashMap<String, Instance>(oldService.getHosts().size());
        for (Object host2 : oldService.getHosts()) {
            oldHostMap.put(host2.toInetAddr(), (Instance)host2);
        }
        HashMap<String, Instance> newHostMap = new HashMap<String, Instance>(newService.getHosts().size());
        for (Instance host3 : newService.getHosts()) {
            newHostMap.put(host3.toInetAddr(), host3);
        }
        HashSet<Instance> modHosts = new HashSet<Instance>();
        HashSet<Instance> newHosts = new HashSet<Instance>();
        HashSet<Instance> remvHosts = new HashSet<Instance>();
        ArrayList newServiceHosts = new ArrayList(newHostMap.entrySet());
        for (Map.Entry entry : newServiceHosts) {
            host = (Instance)entry.getValue();
            key = (String)entry.getKey();
            if (oldHostMap.containsKey(key) && !StringUtils.equals((String)host.toString(), (String)((Instance)oldHostMap.get(key)).toString())) {
                modHosts.add(host);
                continue;
            }
            if (oldHostMap.containsKey(key)) continue;
            newHosts.add(host);
        }
        for (Map.Entry entry : oldHostMap.entrySet()) {
            host = (Instance)entry.getValue();
            key = (String)entry.getKey();
            if (newHostMap.containsKey(key)) continue;
            remvHosts.add(host);
        }
        if (newHosts.size() > 0) {
            LogUtils.NAMING_LOGGER.info("new ips({}) service: {} -> {}", new Object[]{newHosts.size(), newService.getKey(), JacksonUtils.toJson(newHosts)});
            instancesDiff.setAddedInstances(newHosts);
        }
        if (remvHosts.size() > 0) {
            LogUtils.NAMING_LOGGER.info("removed ips({}) service: {} -> {}", new Object[]{remvHosts.size(), newService.getKey(), JacksonUtils.toJson(remvHosts)});
            instancesDiff.setRemovedInstances(remvHosts);
        }
        if (modHosts.size() > 0) {
            LogUtils.NAMING_LOGGER.info("modified ips({}) service: {} -> {}", new Object[]{modHosts.size(), newService.getKey(), JacksonUtils.toJson(modHosts)});
            instancesDiff.setModifiedInstances(modHosts);
        }
        return instancesDiff;
    }
}

