/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.injector;

import com.alibaba.nacos.client.auth.ram.RamContext;
import com.alibaba.nacos.client.auth.ram.identify.StsConfig;
import com.alibaba.nacos.client.auth.ram.identify.StsCredential;
import com.alibaba.nacos.client.auth.ram.identify.StsCredentialHolder;
import com.alibaba.nacos.client.auth.ram.injector.AbstractResourceInjector;
import com.alibaba.nacos.client.auth.ram.utils.CalculateV4SigningKeyUtil;
import com.alibaba.nacos.client.auth.ram.utils.SpasAdapter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import java.util.Map;

public class ConfigResourceInjector
extends AbstractResourceInjector {
    private static final String ACCESS_KEY_HEADER = "Spas-AccessKey";
    private static final String DEFAULT_RESOURCE = "";

    @Override
    public void doInject(RequestResource resource, RamContext context, LoginIdentityContext result) {
        String accessKey = context.getAccessKey();
        String secretKey = context.getSecretKey();
        if (StsConfig.getInstance().isStsOn()) {
            StsCredential stsCredential = StsCredentialHolder.getInstance().getStsCredential();
            accessKey = stsCredential.getAccessKeyId();
            secretKey = stsCredential.getAccessKeySecret();
            result.setParameter("Spas-SecurityToken", stsCredential.getSecurityToken());
        }
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotBlank((String)secretKey)) {
            result.setParameter(ACCESS_KEY_HEADER, accessKey);
        }
        String signatureKey = secretKey;
        if (StringUtils.isNotEmpty((String)context.getRegionId())) {
            signatureKey = CalculateV4SigningKeyUtil.finalSigningKeyStringWithDefaultInfo(secretKey, context.getRegionId());
            result.setParameter("signatureVersion", "v4");
        }
        Map<String, String> signHeaders = SpasAdapter.getSignHeaders(this.getResource(resource.getNamespace(), resource.getGroup()), signatureKey);
        result.setParameters(signHeaders);
    }

    private String getResource(String tenant, String group) {
        if (StringUtils.isBlank((CharSequence)tenant)) {
            if (StringUtils.isBlank((CharSequence)group)) {
                return DEFAULT_RESOURCE;
            }
            return group;
        }
        return tenant + "+" + group;
    }
}

