/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth;

import com.alibaba.nacos.auth.AbstractProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.context.HttpIdentityContextBuilder;
import com.alibaba.nacos.auth.parser.http.AbstractHttpResourceParser;
import com.alibaba.nacos.auth.parser.http.AiHttpResourceParser;
import com.alibaba.nacos.auth.parser.http.ConfigHttpResourceParser;
import com.alibaba.nacos.auth.parser.http.NamingHttpResourceParser;
import com.alibaba.nacos.auth.serveridentity.ServerIdentity;
import com.alibaba.nacos.auth.util.Loggers;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

public class HttpProtocolAuthService
extends AbstractProtocolAuthService<HttpServletRequest> {
    private final Map<String, AbstractHttpResourceParser> resourceParserMap = new HashMap<String, AbstractHttpResourceParser>(2);
    private final HttpIdentityContextBuilder identityContextBuilder;

    public HttpProtocolAuthService(NacosAuthConfig authConfig) {
        super(authConfig);
        this.identityContextBuilder = new HttpIdentityContextBuilder(authConfig);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.resourceParserMap.put("naming", new NamingHttpResourceParser());
        this.resourceParserMap.put("config", new ConfigHttpResourceParser());
        this.resourceParserMap.put("ai", new AiHttpResourceParser());
    }

    @Override
    public Resource parseResource(HttpServletRequest request, Secured secured) {
        if (StringUtils.isNotBlank((String)secured.resource())) {
            return this.parseSpecifiedResource(secured);
        }
        String type = secured.signType();
        if (!this.resourceParserMap.containsKey(type)) {
            Loggers.AUTH.warn("Can't find Http request resourceParser for type {} use specified resource parser", (Object)type);
            return this.useSpecifiedParserToParse(secured, request);
        }
        return this.resourceParserMap.get(type).parse(request, secured);
    }

    @Override
    public IdentityContext parseIdentity(HttpServletRequest request) {
        return this.identityContextBuilder.build(request);
    }

    @Override
    protected ServerIdentity parseServerIdentity(HttpServletRequest request) {
        String serverIdentityKey = this.authConfig.getServerIdentityKey();
        String serverIdentity = request.getHeader(serverIdentityKey);
        return new ServerIdentity(serverIdentityKey, serverIdentity);
    }
}

