/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.users;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.persistence.UserPersistService;
import com.alibaba.nacos.plugin.auth.impl.users.AbstractCachedUserService;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetails;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserService;
import com.alibaba.nacos.plugin.auth.impl.utils.PasswordEncoderUtil;
import java.util.List;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class NacosUserServiceDirectImpl
extends AbstractCachedUserService
implements NacosUserService {
    private final UserPersistService userPersistService;
    private final AuthConfigs authConfigs;

    public NacosUserServiceDirectImpl(AuthConfigs authConfigs, UserPersistService userPersistService) {
        this.userPersistService = userPersistService;
        this.authConfigs = authConfigs;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.getCachedUserMap().get(username);
        if (!this.authConfigs.isCachingEnabled()) {
            user = this.getUser(username);
        }
        if (user == null) {
            throw new UsernameNotFoundException(String.format("User %s not found", username));
        }
        return new NacosUserDetails(user);
    }

    @Override
    public void updateUserPassword(String username, String password) {
        this.userPersistService.updateUserPassword(username, PasswordEncoderUtil.encode(password));
    }

    @Override
    public Page<User> getUsers(int pageNo, int pageSize, String username) {
        return this.userPersistService.getUsers(pageNo, pageSize, username);
    }

    @Override
    public User getUser(String username) {
        return this.userPersistService.findUserByUsername(username);
    }

    @Override
    public List<String> findUserNames(String username) {
        return this.userPersistService.findUserLikeUsername(username);
    }

    @Override
    public void createUser(String username, String password, boolean encode) {
        if (encode) {
            password = PasswordEncoderUtil.encode(password);
        }
        this.userPersistService.createUser(username, password);
    }

    @Override
    public void deleteUser(String username) {
        this.userPersistService.deleteUser(username);
    }

    @Override
    public Page<User> findUsers(String username, int pageNo, int pageSize) {
        return this.userPersistService.findUsersLike4Page(username, pageNo, pageSize);
    }
}

