/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.roles;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class AbstractCachedRoleService
implements NacosRoleService {
    protected static final int DEFAULT_PAGE_NO = 1;
    private volatile Set<String> roleSet = new ConcurrentHashSet();
    private volatile Map<String, List<RoleInfo>> roleInfoMap = new ConcurrentHashMap<String, List<RoleInfo>>();
    private volatile Map<String, List<PermissionInfo>> permissionInfoMap = new ConcurrentHashMap<String, List<PermissionInfo>>();

    protected Set<String> getCachedRoleSet() {
        return this.roleSet;
    }

    protected Map<String, List<RoleInfo>> getCachedRoleInfoMap() {
        return this.roleInfoMap;
    }

    protected Map<String, List<PermissionInfo>> getCachedPermissionInfoMap() {
        return this.permissionInfoMap;
    }

    @Scheduled(initialDelay=5000L, fixedDelay=15000L)
    protected void reload() {
        try {
            List<RoleInfo> roleInfoPage = this.getAllRoles();
            HashSet<String> tmpRoleSet = new HashSet<String>(16);
            ConcurrentHashMap<String, List<RoleInfo>> tmpRoleInfoMap = new ConcurrentHashMap<String, List<RoleInfo>>(16);
            for (RoleInfo roleInfo : roleInfoPage) {
                if (!tmpRoleInfoMap.containsKey(roleInfo.getUsername())) {
                    tmpRoleInfoMap.put(roleInfo.getUsername(), new ArrayList());
                }
                ((List)tmpRoleInfoMap.get(roleInfo.getUsername())).add(roleInfo);
                tmpRoleSet.add(roleInfo.getRole());
            }
            ConcurrentHashMap<String, List<PermissionInfo>> tmpPermissionInfoMap = new ConcurrentHashMap<String, List<PermissionInfo>>(16);
            for (String role : tmpRoleSet) {
                Page<PermissionInfo> permissionInfoPage = this.getPermissions(role, 1, Integer.MAX_VALUE);
                tmpPermissionInfoMap.put(role, permissionInfoPage.getPageItems());
            }
            this.roleSet = tmpRoleSet;
            this.roleInfoMap = tmpRoleInfoMap;
            this.permissionInfoMap = tmpPermissionInfoMap;
        }
        catch (Exception e) {
            Loggers.AUTH.warn("[LOAD-ROLES] load failed", (Throwable)e);
        }
    }
}

