/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller.v3;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.authenticate.IAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthSystemTypes;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManagerDelegate;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserService;
import com.alibaba.nacos.plugin.auth.impl.utils.PasswordGeneratorUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/auth/user"})
public class UserControllerV3 {
    private final NacosUserService userDetailsService;
    private final NacosRoleService roleService;
    private final AuthConfigs authConfigs;
    private final IAuthenticationManager iAuthenticationManager;
    private final TokenManagerDelegate jwtTokenManager;
    private static final String SEARCH_TYPE_BLUR = "blur";

    public UserControllerV3(NacosUserService userDetailsService, NacosRoleService roleService, AuthConfigs authConfigs, IAuthenticationManager iAuthenticationManager, TokenManagerDelegate jwtTokenManager) {
        this.userDetailsService = userDetailsService;
        this.roleService = roleService;
        this.authConfigs = authConfigs;
        this.iAuthenticationManager = iAuthenticationManager;
        this.jwtTokenManager = jwtTokenManager;
    }

    @Secured(resource="console/users", action=ActionTypes.WRITE)
    @PostMapping
    public Result<String> createUser(@RequestParam String username, @RequestParam String password) {
        User user = this.userDetailsService.getUser(username);
        if (user != null) {
            throw new IllegalArgumentException("user '" + username + "' already exist!");
        }
        this.userDetailsService.createUser(username, password);
        return Result.success((Object)"create user ok!");
    }

    @PostMapping(value={"/admin"})
    public Result<User> createAdminUser(@RequestParam(required=false) String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            password = PasswordGeneratorUtil.generateRandomPassword();
        }
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            if (this.iAuthenticationManager.hasGlobalAdminRole()) {
                return Result.failure((Integer)HttpStatus.CONFLICT.value(), (String)"have admin user cannot use it.", null);
            }
            String username = "nacos";
            this.userDetailsService.createUser(username, password);
            this.roleService.addAdminRole(username);
            User result = new User();
            result.setUsername(username);
            result.setPassword(password);
            return Result.success((Object)result);
        }
        return Result.failure((Integer)HttpStatus.NOT_IMPLEMENTED.value(), (String)"Current auth type not supported create admin user.", null);
    }

    @DeleteMapping
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    public Result<String> deleteUser(@RequestParam String username) {
        List<RoleInfo> roleInfoList = this.roleService.getRoles(username);
        if (roleInfoList != null) {
            for (RoleInfo roleInfo : roleInfoList) {
                if (!"ROLE_ADMIN".equals(roleInfo.getRole())) continue;
                throw new IllegalArgumentException("cannot delete admin: " + username);
            }
        }
        this.userDetailsService.deleteUser(username);
        return Result.success((Object)"delete user ok!");
    }

    @PutMapping
    @Secured(resource="console/user/password", action=ActionTypes.WRITE, tags={"only_identity", "console/user/password"})
    public Result<String> updateUser(@RequestParam String username, @RequestParam String newPassword, HttpServletResponse response, HttpServletRequest request) throws IOException {
        try {
            if (!this.hasPermission(username, request)) {
                response.sendError(403, "authorization failed!");
                return null;
            }
        }
        catch (HttpSessionRequiredException e) {
            response.sendError(401, "session expired!");
            return null;
        }
        catch (AccessException exception) {
            response.sendError(403, "authorization failed!");
            return null;
        }
        User user = this.userDetailsService.getUser(username);
        if (user == null) {
            throw new IllegalArgumentException("user " + username + " not exist!");
        }
        this.userDetailsService.updateUserPassword(username, newPassword);
        return Result.success((Object)"update user ok!");
    }

    private boolean hasPermission(String username, HttpServletRequest request) throws HttpSessionRequiredException, AccessException {
        if (!NacosAuthConfigHolder.getInstance().isAnyAuthEnabled()) {
            return true;
        }
        IdentityContext identityContext = RequestContextHolder.getContext().getAuthContext().getIdentityContext();
        if (identityContext == null) {
            throw new HttpSessionRequiredException("session expired!");
        }
        NacosUser user = (NacosUser)identityContext.getParameter("nacosuser");
        if (user == null) {
            user = this.iAuthenticationManager.authenticate(request);
            if (user == null) {
                throw new HttpSessionRequiredException("session expired!");
            }
            this.iAuthenticationManager.hasGlobalAdminRole(user);
        }
        if (user.isGlobalAdmin()) {
            return true;
        }
        return user.getUserName().equals(username);
    }

    @GetMapping(value={"/list"})
    @Secured(resource="console/users", action=ActionTypes.READ)
    public Result<Page<User>> getUserList(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", required=false, defaultValue="") String username, @RequestParam(name="search", required=false, defaultValue="accurate") String search) {
        Page<User> userPage = SEARCH_TYPE_BLUR.equalsIgnoreCase(search) ? this.userDetailsService.findUsers(username, pageNo, pageSize) : this.userDetailsService.getUsers(pageNo, pageSize, username);
        return Result.success(userPage);
    }

    @GetMapping(value={"/search"})
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    public Result<List<String>> getUserListByUsername(@RequestParam String username) {
        List<String> userList = this.userDetailsService.findUserNames(username);
        return Result.success(userList);
    }

    @PostMapping(value={"/login"})
    public Object login(HttpServletResponse response, HttpServletRequest request) throws AccessException, IOException {
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType()) || AuthSystemTypes.LDAP.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            NacosUser user = this.iAuthenticationManager.authenticate(request);
            response.addHeader("Authorization", "Bearer " + user.getToken());
            ObjectNode result = JacksonUtils.createEmptyJsonNode();
            result.put("accessToken", user.getToken());
            result.put("tokenTtl", this.jwtTokenManager.getTokenTtlInSeconds(user.getToken()));
            result.put("globalAdmin", this.iAuthenticationManager.hasGlobalAdminRole(user));
            result.put("username", user.getUserName());
            return result;
        }
        return Result.failure((Integer)ErrorCode.ILLEGAL_STATE.getCode(), (String)"Current Nacos auth plugin type is not `nacos` or `nacos-ldap`, don't support login API.", null);
    }
}

