/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth/roles"})
public class RoleController {
    private final NacosRoleService roleService;

    public RoleController(NacosRoleService roleService) {
        this.roleService = roleService;
    }

    @GetMapping(params={"search=accurate"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/role/list")
    public Object getRoles(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", defaultValue="") String username, @RequestParam(name="role", defaultValue="") String role) {
        return this.roleService.getRoles(username, role, pageNo, pageSize);
    }

    @GetMapping(params={"search=blur"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/role/list")
    public Page<RoleInfo> fuzzySearchRole(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", defaultValue="") String username, @RequestParam(name="role", defaultValue="") String role) {
        return this.roleService.findRoles(username, role, pageNo, pageSize);
    }

    @GetMapping(value={"/search"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/auth/role/search")
    public List<String> searchRoles(@RequestParam String role) {
        return this.roleService.findRoleNames(role);
    }

    @PostMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="POST ${contextPath:nacos}/v3/auth/role")
    public Object addRole(@RequestParam String role, @RequestParam String username) {
        this.roleService.addRole(role, username);
        return RestResultUtils.success((Object)"add role ok!");
    }

    @DeleteMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="DELETE ${contextPath:nacos}/v3/auth/role")
    public Object deleteRole(@RequestParam String role, @RequestParam(name="username", defaultValue="") String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            this.roleService.deleteRole(role);
        } else {
            this.roleService.deleteRole(role, username);
        }
        return RestResultUtils.success((Object)("delete role of user " + username + " ok!"));
    }
}

