/*
 * Decompiled with CFR 0.152.
 */
package feign.form.multipart;

import feign.codec.EncodeException;
import feign.form.multipart.AbstractWriter;
import feign.form.multipart.Output;
import feign.form.multipart.SingleFileWriter;
import java.io.File;
import java.util.Iterator;

public class ManyFilesWriter
extends AbstractWriter {
    private final SingleFileWriter fileWriter = new SingleFileWriter();

    @Override
    public boolean isApplicable(Object value) {
        if (value instanceof File[]) {
            return true;
        }
        if (!(value instanceof Iterable)) {
            return false;
        }
        Iterable iterable = (Iterable)value;
        Iterator iterator = iterable.iterator();
        return iterator.hasNext() && iterator.next() instanceof File;
    }

    @Override
    public void write(Output output, String boundary, String key, Object value) throws EncodeException {
        if (value instanceof File[]) {
            File[] files;
            for (File file : files = (File[])value) {
                this.fileWriter.write(output, boundary, key, file);
            }
        } else if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            for (Object file : iterable) {
                this.fileWriter.write(output, boundary, key, file);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }
}

