/*
 * Decompiled with CFR 0.152.
 */
package io.agora.media;

import io.agora.media.DynamicKeyUtil;
import java.io.ByteArrayOutputStream;

public class DynamicKey4 {
    private static final String PUBLIC_SHARING_SERVICE = "APSS";
    private static final String RECORDING_SERVICE = "ARS";
    private static final String MEDIA_CHANNEL_SERVICE = "ACS";

    public static String generatePublicSharingKey(String appID, String appCertificate, String channelName, int unixTs, int randomInt, long uid, int expiredTs) throws Exception {
        return DynamicKey4.doGenerate(appID, appCertificate, channelName, unixTs, randomInt, uid, expiredTs, PUBLIC_SHARING_SERVICE);
    }

    public static String generateRecordingKey(String appID, String appCertificate, String channelName, int unixTs, int randomInt, long uid, int expiredTs) throws Exception {
        return DynamicKey4.doGenerate(appID, appCertificate, channelName, unixTs, randomInt, uid, expiredTs, RECORDING_SERVICE);
    }

    public static String generateMediaChannelKey(String appID, String appCertificate, String channelName, int unixTs, int randomInt, long uid, int expiredTs) throws Exception {
        return DynamicKey4.doGenerate(appID, appCertificate, channelName, unixTs, randomInt, uid, expiredTs, MEDIA_CHANNEL_SERVICE);
    }

    private static String doGenerate(String appID, String appCertificate, String channelName, int unixTs, int randomInt, long uid, int expiredTs, String serviceType) throws Exception {
        String version = "004";
        String unixTsStr = ("0000000000" + Integer.toString(unixTs)).substring(Integer.toString(unixTs).length());
        String randomIntStr = ("00000000" + Integer.toHexString(randomInt)).substring(Integer.toHexString(randomInt).length());
        String uidStr = ("0000000000" + Long.toString(uid &= 0xFFFFFFFFL)).substring(Long.toString(uid).length());
        String expiredTsStr = ("0000000000" + Integer.toString(expiredTs)).substring(Integer.toString(expiredTs).length());
        String signature = DynamicKey4.generateSignature4(appID, appCertificate, channelName, unixTsStr, randomIntStr, uidStr, expiredTsStr, serviceType);
        return String.format("%s%s%s%s%s%s", version, signature, appID, unixTsStr, randomIntStr, expiredTsStr);
    }

    private static String generateSignature4(String appID, String appCertificate, String channelName, String unixTsStr, String randomIntStr, String uidStr, String expiredTsStr, String serviceType) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(serviceType.getBytes());
        baos.write(appID.getBytes());
        baos.write(unixTsStr.getBytes());
        baos.write(randomIntStr.getBytes());
        baos.write(channelName.getBytes());
        baos.write(uidStr.getBytes());
        baos.write(expiredTsStr.getBytes());
        byte[] sign = DynamicKeyUtil.encodeHMAC(appCertificate, baos.toByteArray());
        return DynamicKeyUtil.bytesToHex(sign);
    }
}

