/*
 * Decompiled with CFR 0.152.
 */
package io.agora.media;

import io.agora.media.ByteBuf;
import io.agora.media.Utils;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AccessToken2 {
    private static final String VERSION = "007";
    public static final short SERVICE_TYPE_RTC = 1;
    public static final short SERVICE_TYPE_RTM = 2;
    public static final short SERVICE_TYPE_FPA = 4;
    public static final short SERVICE_TYPE_CHAT = 5;
    public static final short SERVICE_TYPE_APAAS = 7;
    public String appCert = "";
    public String appId = "";
    public int expire;
    public int issueTs;
    public int salt;
    public Map<Short, Service> services = new TreeMap<Short, Service>();

    public AccessToken2() {
    }

    public AccessToken2(String appId, String appCert, int expire) {
        this.appCert = appCert;
        this.appId = appId;
        this.expire = expire;
        this.issueTs = Utils.getTimestamp();
        this.salt = Utils.randomInt();
    }

    public void addService(Service service) {
        this.services.put(service.getServiceType(), service);
    }

    public String build() throws Exception {
        if (!Utils.isUUID(this.appId) || !Utils.isUUID(this.appCert)) {
            return "";
        }
        ByteBuf buf = new ByteBuf().put(this.appId).put(this.issueTs).put(this.expire).put(this.salt).put((short)this.services.size());
        byte[] signing = this.getSign();
        this.services.forEach((k, v) -> v.pack(buf));
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(signing, "HmacSHA256"));
        byte[] signature = mac.doFinal(buf.asBytes());
        ByteBuf bufferContent = new ByteBuf();
        bufferContent.put(signature);
        bufferContent.buffer.put(buf.asBytes());
        return AccessToken2.getVersion() + Utils.base64Encode(Utils.compress(bufferContent.asBytes()));
    }

    public Service getService(short serviceType) {
        if (serviceType == 1) {
            return new ServiceRtc();
        }
        if (serviceType == 2) {
            return new ServiceRtm();
        }
        if (serviceType == 4) {
            return new ServiceFpa();
        }
        if (serviceType == 5) {
            return new ServiceChat();
        }
        if (serviceType == 7) {
            return new ServiceApaas();
        }
        throw new IllegalArgumentException(String.format("unknown service type: `%d`", serviceType));
    }

    public byte[] getSign() throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(new ByteBuf().put(this.issueTs).asBytes(), "HmacSHA256"));
        byte[] signing = mac.doFinal(this.appCert.getBytes());
        mac.init(new SecretKeySpec(new ByteBuf().put(this.salt).asBytes(), "HmacSHA256"));
        return mac.doFinal(signing);
    }

    public static String getUidStr(int uid) {
        if (uid == 0) {
            return "";
        }
        return String.valueOf((long)uid & 0xFFFFFFFFL);
    }

    public static String getVersion() {
        return VERSION;
    }

    public boolean parse(String token) {
        if (!AccessToken2.getVersion().equals(token.substring(0, 3))) {
            return false;
        }
        try {
            byte[] data = Utils.decompress(Utils.base64Decode(token.substring(3)));
            ByteBuf buff = new ByteBuf(data);
            String signature = buff.readString();
            this.appId = buff.readString();
            this.issueTs = buff.readInt();
            this.expire = buff.readInt();
            this.salt = buff.readInt();
            int servicesNum = buff.readShort();
            for (int i = 0; i < servicesNum; ++i) {
                short serviceType = buff.readShort();
                Service service = this.getService(serviceType);
                service.unpack(buff);
                this.services.put(serviceType, service);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static class ServiceApaas
    extends Service {
        public String roomUuid;
        public String userUuid;
        public Short role;

        public ServiceApaas() {
            this.type = (short)7;
            this.roomUuid = "";
            this.userUuid = "";
            this.role = -1;
        }

        public ServiceApaas(String roomUuid, String userUuid, Short role) {
            this.type = (short)7;
            this.roomUuid = roomUuid;
            this.userUuid = userUuid;
            this.role = role;
        }

        public ServiceApaas(String userUuid) {
            this.type = (short)7;
            this.roomUuid = "";
            this.userUuid = userUuid;
            this.role = -1;
        }

        public String getRoomUuid() {
            return this.roomUuid;
        }

        public String getUserUuid() {
            return this.userUuid;
        }

        public Short getRole() {
            return this.role;
        }

        @Override
        public ByteBuf pack(ByteBuf buf) {
            return super.pack(buf).put(this.roomUuid).put(this.userUuid).put(this.role);
        }

        @Override
        public void unpack(ByteBuf byteBuf) {
            super.unpack(byteBuf);
            this.roomUuid = byteBuf.readString();
            this.userUuid = byteBuf.readString();
            this.role = byteBuf.readShort();
        }
    }

    public static class ServiceChat
    extends Service {
        public String userId;

        public ServiceChat() {
            this.type = (short)5;
            this.userId = "";
        }

        public ServiceChat(String userId) {
            this.type = (short)5;
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        @Override
        public ByteBuf pack(ByteBuf buf) {
            return super.pack(buf).put(this.userId);
        }

        @Override
        public void unpack(ByteBuf byteBuf) {
            super.unpack(byteBuf);
            this.userId = byteBuf.readString();
        }
    }

    public static class ServiceFpa
    extends Service {
        public ServiceFpa() {
            this.type = (short)4;
        }

        @Override
        public ByteBuf pack(ByteBuf buf) {
            return super.pack(buf);
        }

        @Override
        public void unpack(ByteBuf byteBuf) {
            super.unpack(byteBuf);
        }
    }

    public static class ServiceRtm
    extends Service {
        public String userId;

        public ServiceRtm() {
            this.type = (short)2;
        }

        public ServiceRtm(String userId) {
            this.type = (short)2;
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        @Override
        public ByteBuf pack(ByteBuf buf) {
            return super.pack(buf).put(this.userId);
        }

        @Override
        public void unpack(ByteBuf byteBuf) {
            super.unpack(byteBuf);
            this.userId = byteBuf.readString();
        }
    }

    public static class ServiceRtc
    extends Service {
        public String channelName;
        public String uid;

        public ServiceRtc() {
            this.type = 1;
        }

        public ServiceRtc(String channelName, String uid) {
            this.type = 1;
            this.channelName = channelName;
            this.uid = uid;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public String getUid() {
            return this.uid;
        }

        @Override
        public ByteBuf pack(ByteBuf buf) {
            return super.pack(buf).put(this.channelName).put(this.uid);
        }

        @Override
        public void unpack(ByteBuf byteBuf) {
            super.unpack(byteBuf);
            this.channelName = byteBuf.readString();
            this.uid = byteBuf.readString();
        }
    }

    public static class Service {
        public short type;
        public TreeMap<Short, Integer> privileges = new TreeMap<Short, Integer>(this){
            final /* synthetic */ Service this$0;
            {
                this.this$0 = this$0;
            }
        };

        public Service() {
        }

        public Service(short serviceType) {
            this.type = serviceType;
        }

        public void addPrivilegeRtc(PrivilegeRtc privilege, int expire) {
            this.privileges.put(privilege.intValue, expire);
        }

        public void addPrivilegeRtm(PrivilegeRtm privilege, int expire) {
            this.privileges.put(privilege.intValue, expire);
        }

        public void addPrivilegeFpa(PrivilegeFpa privilege, int expire) {
            this.privileges.put(privilege.intValue, expire);
        }

        public void addPrivilegeChat(PrivilegeChat privilege, int expire) {
            this.privileges.put(privilege.intValue, expire);
        }

        public void addPrivilegeApaas(PrivilegeApaas privilege, int expire) {
            this.privileges.put(privilege.intValue, expire);
        }

        public TreeMap<Short, Integer> getPrivileges() {
            return this.privileges;
        }

        public short getServiceType() {
            return this.type;
        }

        public ByteBuf pack(ByteBuf buf) {
            return buf.put(this.type).putIntMap(this.privileges);
        }

        public void unpack(ByteBuf byteBuf) {
            this.privileges = byteBuf.readIntMap();
        }
    }

    public static enum PrivilegeApaas {
        PRIVILEGE_ROOM_USER(1),
        PRIVILEGE_USER(2),
        PRIVILEGE_APP(3);

        public short intValue;

        private PrivilegeApaas(int value) {
            this.intValue = (short)value;
        }
    }

    public static enum PrivilegeChat {
        PRIVILEGE_CHAT_USER(1),
        PRIVILEGE_CHAT_APP(2);

        public short intValue;

        private PrivilegeChat(int value) {
            this.intValue = (short)value;
        }
    }

    public static enum PrivilegeFpa {
        PRIVILEGE_LOGIN(1);

        public short intValue;

        private PrivilegeFpa(int value) {
            this.intValue = (short)value;
        }
    }

    public static enum PrivilegeRtm {
        PRIVILEGE_LOGIN(1);

        public short intValue;

        private PrivilegeRtm(int value) {
            this.intValue = (short)value;
        }
    }

    public static enum PrivilegeRtc {
        PRIVILEGE_JOIN_CHANNEL(1),
        PRIVILEGE_PUBLISH_AUDIO_STREAM(2),
        PRIVILEGE_PUBLISH_VIDEO_STREAM(3),
        PRIVILEGE_PUBLISH_DATA_STREAM(4);

        public short intValue;

        private PrivilegeRtc(int value) {
            this.intValue = (short)value;
        }
    }
}

