/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api.buildplan;

import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FilePermissions {
    public static final FilePermissions DEFAULT_FILE_PERMISSIONS = new FilePermissions(420);
    public static final FilePermissions DEFAULT_FOLDER_PERMISSIONS = new FilePermissions(493);
    private static final String OCTAL_PATTERN = "[0-7][0-7][0-7]";
    private static final Map<PosixFilePermission, Integer> PERMISSION_MAP;
    private final int permissionBits;

    public static FilePermissions fromOctalString(String octalPermissions) {
        if (!octalPermissions.matches(OCTAL_PATTERN)) {
            throw new IllegalArgumentException("octalPermissions must be a 3-digit octal number (000-777)");
        }
        return new FilePermissions(Integer.parseInt(octalPermissions, 8));
    }

    public static FilePermissions fromPosixFilePermissions(Set<PosixFilePermission> posixFilePermissions) {
        int permissionBits = 0;
        for (PosixFilePermission permission : posixFilePermissions) {
            permissionBits |= Objects.requireNonNull(PERMISSION_MAP.get((Object)permission)).intValue();
        }
        return new FilePermissions(permissionBits);
    }

    FilePermissions(int permissionBits) {
        this.permissionBits = permissionBits;
    }

    public int getPermissionBits() {
        return this.permissionBits;
    }

    public String toOctalString() {
        return Integer.toString(this.permissionBits, 8);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FilePermissions)) {
            return false;
        }
        FilePermissions otherFilePermissions = (FilePermissions)other;
        return this.permissionBits == otherFilePermissions.permissionBits;
    }

    public int hashCode() {
        return this.permissionBits;
    }

    static {
        HashMap<PosixFilePermission, Integer> map = new HashMap<PosixFilePermission, Integer>(9);
        map.put(PosixFilePermission.OWNER_READ, 256);
        map.put(PosixFilePermission.OWNER_WRITE, 128);
        map.put(PosixFilePermission.OWNER_EXECUTE, 64);
        map.put(PosixFilePermission.GROUP_READ, 32);
        map.put(PosixFilePermission.GROUP_WRITE, 16);
        map.put(PosixFilePermission.GROUP_EXECUTE, 8);
        map.put(PosixFilePermission.OTHERS_READ, 4);
        map.put(PosixFilePermission.OTHERS_WRITE, 2);
        map.put(PosixFilePermission.OTHERS_EXECUTE, 1);
        PERMISSION_MAP = Collections.unmodifiableMap(map);
    }
}

