/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoTileGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompositeAggregationSource
implements JsonpSerializable {
    @Nullable
    private final TermsAggregation terms;
    @Nullable
    private final HistogramAggregation histogram;
    @Nullable
    private final DateHistogramAggregation dateHistogram;
    @Nullable
    private final GeoTileGridAggregation geotileGrid;
    public static final JsonpDeserializer<CompositeAggregationSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregationSource::setupCompositeAggregationSourceDeserializer);

    private CompositeAggregationSource(Builder builder) {
        this.terms = builder.terms;
        this.histogram = builder.histogram;
        this.dateHistogram = builder.dateHistogram;
        this.geotileGrid = builder.geotileGrid;
    }

    public static CompositeAggregationSource of(Function<Builder, ObjectBuilder<CompositeAggregationSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TermsAggregation terms() {
        return this.terms;
    }

    @Nullable
    public final HistogramAggregation histogram() {
        return this.histogram;
    }

    @Nullable
    public final DateHistogramAggregation dateHistogram() {
        return this.dateHistogram;
    }

    @Nullable
    public final GeoTileGridAggregation geotileGrid() {
        return this.geotileGrid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.terms != null) {
            generator.writeKey("terms");
            this.terms.serialize(generator, mapper);
        }
        if (this.histogram != null) {
            generator.writeKey("histogram");
            this.histogram.serialize(generator, mapper);
        }
        if (this.dateHistogram != null) {
            generator.writeKey("date_histogram");
            this.dateHistogram.serialize(generator, mapper);
        }
        if (this.geotileGrid != null) {
            generator.writeKey("geotile_grid");
            this.geotileGrid.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCompositeAggregationSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::terms, TermsAggregation._DESERIALIZER, "terms");
        op.add(Builder::histogram, HistogramAggregation._DESERIALIZER, "histogram");
        op.add(Builder::dateHistogram, DateHistogramAggregation._DESERIALIZER, "date_histogram");
        op.add(Builder::geotileGrid, GeoTileGridAggregation._DESERIALIZER, "geotile_grid");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CompositeAggregationSource> {
        @Nullable
        private TermsAggregation terms;
        @Nullable
        private HistogramAggregation histogram;
        @Nullable
        private DateHistogramAggregation dateHistogram;
        @Nullable
        private GeoTileGridAggregation geotileGrid;

        public final Builder terms(@Nullable TermsAggregation value) {
            this.terms = value;
            return this;
        }

        public final Builder terms(Function<TermsAggregation.Builder, ObjectBuilder<TermsAggregation>> fn) {
            return this.terms(fn.apply(new TermsAggregation.Builder()).build());
        }

        public final Builder histogram(@Nullable HistogramAggregation value) {
            this.histogram = value;
            return this;
        }

        public final Builder histogram(Function<HistogramAggregation.Builder, ObjectBuilder<HistogramAggregation>> fn) {
            return this.histogram(fn.apply(new HistogramAggregation.Builder()).build());
        }

        public final Builder dateHistogram(@Nullable DateHistogramAggregation value) {
            this.dateHistogram = value;
            return this;
        }

        public final Builder dateHistogram(Function<DateHistogramAggregation.Builder, ObjectBuilder<DateHistogramAggregation>> fn) {
            return this.dateHistogram(fn.apply(new DateHistogramAggregation.Builder()).build());
        }

        public final Builder geotileGrid(@Nullable GeoTileGridAggregation value) {
            this.geotileGrid = value;
            return this;
        }

        public final Builder geotileGrid(Function<GeoTileGridAggregation.Builder, ObjectBuilder<GeoTileGridAggregation>> fn) {
            return this.geotileGrid(fn.apply(new GeoTileGridAggregation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeAggregationSource build() {
            this._checkSingleUse();
            return new CompositeAggregationSource(this);
        }
    }
}

