/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import tech.tablesaw.analytic.AggregateFunctions;
import tech.tablesaw.analytic.FunctionMetaData;
import tech.tablesaw.analytic.NumberingFunctions;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.Column;

final class ArgumentList {
    private final Map<String, FunctionCall<AggregateFunctions>> aggregateFunctions;
    private final Map<String, FunctionCall<NumberingFunctions>> numberingFunctions;
    private final Set<String> newColumnNames;

    private ArgumentList(Map<String, FunctionCall<AggregateFunctions>> aggregateFunctions, Map<String, FunctionCall<NumberingFunctions>> numberingFunctions, Set<String> newColumnNames) {
        this.aggregateFunctions = aggregateFunctions;
        this.numberingFunctions = numberingFunctions;
        this.newColumnNames = newColumnNames;
    }

    static Builder builder() {
        return new Builder();
    }

    public Map<String, FunctionCall<AggregateFunctions>> getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    public Map<String, FunctionCall<NumberingFunctions>> getNumberingFunctions() {
        return this.numberingFunctions;
    }

    public List<String> getNewColumnNames() {
        return ImmutableList.copyOf(this.newColumnNames);
    }

    public String toSqlString(String windowName) {
        StringBuilder sb = new StringBuilder();
        int colCount = 0;
        for (String newColName : this.newColumnNames) {
            String optionalNumberingCol = Optional.ofNullable(this.numberingFunctions.get(newColName)).map(f -> f.toSqlString(windowName)).orElse("");
            String optionalAggregateCol = Optional.ofNullable(this.aggregateFunctions.get(newColName)).map(f -> f.toSqlString(windowName)).orElse("");
            sb.append(optionalNumberingCol);
            sb.append(optionalAggregateCol);
            if (++colCount >= this.newColumnNames.size()) continue;
            sb.append(",");
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    List<Column<?>> createEmptyDestinationColumns(int rowCount) {
        ArrayList newColumns = new ArrayList();
        for (String toColumn : this.newColumnNames) {
            FunctionCall functionCall = Stream.of(this.aggregateFunctions.get(toColumn), this.numberingFunctions.get(toColumn)).filter(Objects::nonNull).findFirst().get();
            ColumnType type = functionCall.function.returnType();
            Column<?> resultColumn = type.create(toColumn);
            newColumns.add(resultColumn);
            for (int i = 0; i < rowCount; ++i) {
                resultColumn.appendMissing();
            }
        }
        return newColumns;
    }

    public String toString() {
        return this.toSqlString("?");
    }

    static class Builder {
        private final Map<String, FunctionCall<AggregateFunctions>> aggregateFunctions = new HashMap<String, FunctionCall<AggregateFunctions>>();
        private final Map<String, FunctionCall<NumberingFunctions>> numberingFunctions = new HashMap<String, FunctionCall<NumberingFunctions>>();
        private final Set<String> newColumnNames = new LinkedHashSet<String>();
        private String stagedFromColumn;
        private AggregateFunctions stagedAggregateFunction;
        private NumberingFunctions stagedNumberingFunction;

        private Builder() {
        }

        Builder stageFunction(String fromColumn, AggregateFunctions function) {
            this.checkNothingStaged();
            Preconditions.checkNotNull((Object)fromColumn);
            Preconditions.checkNotNull((Object)function);
            this.stagedFromColumn = fromColumn;
            this.stagedAggregateFunction = function;
            return this;
        }

        Builder stageFunction(NumberingFunctions function) {
            this.checkNothingStaged();
            Preconditions.checkNotNull((Object)function);
            this.stagedFromColumn = "NUMBERING_FUNCTION_PLACEHOLDER";
            this.stagedNumberingFunction = function;
            return this;
        }

        private void checkNothingStaged() {
            if (this.stagedFromColumn != null) {
                throw new IllegalArgumentException("Cannot stage a column while another is staged. Must call unstage first");
            }
        }

        private void checkForDuplicateAlias(String toColumn) {
            Preconditions.checkArgument((!this.newColumnNames.contains(toColumn) ? 1 : 0) != 0, (Object)("Cannot add duplicate column name: " + toColumn));
            this.newColumnNames.add(toColumn);
        }

        Builder unStageFunction(String toColumn) {
            Preconditions.checkNotNull((Object)this.stagedFromColumn);
            this.checkForDuplicateAlias(toColumn);
            if (this.stagedNumberingFunction != null) {
                Preconditions.checkNotNull((Object)this.stagedNumberingFunction);
                this.numberingFunctions.put(toColumn, new FunctionCall<NumberingFunctions>("", toColumn, this.stagedNumberingFunction));
            } else {
                Preconditions.checkNotNull((Object)this.stagedAggregateFunction);
                this.aggregateFunctions.put(toColumn, new FunctionCall<AggregateFunctions>(this.stagedFromColumn, toColumn, this.stagedAggregateFunction));
            }
            this.stagedNumberingFunction = null;
            this.stagedAggregateFunction = null;
            this.stagedFromColumn = null;
            return this;
        }

        ArgumentList build() {
            if (this.stagedFromColumn != null) {
                throw new IllegalStateException("Cannot build when a column is staged");
            }
            return new ArgumentList(this.aggregateFunctions, this.numberingFunctions, this.newColumnNames);
        }
    }

    static class FunctionCall<T extends FunctionMetaData> {
        private final String sourceColumnName;
        private final String destinationColumnName;
        private final T function;

        public String getSourceColumnName() {
            return this.sourceColumnName;
        }

        public String getDestinationColumnName() {
            return this.destinationColumnName;
        }

        public T getFunction() {
            return this.function;
        }

        public FunctionCall(String sourceColumnName, String destinationColumnName, T function) {
            this.sourceColumnName = sourceColumnName;
            this.destinationColumnName = destinationColumnName;
            this.function = function;
        }

        public String toString() {
            return this.toSqlString("");
        }

        public String toSqlString(String windowName) {
            String over = "";
            if (!windowName.isEmpty()) {
                over = " OVER " + windowName;
            }
            return this.function.toString() + '(' + this.sourceColumnName + ")" + over + " AS " + this.destinationColumnName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionCall that = (FunctionCall)o;
            return com.google.common.base.Objects.equal((Object)this.sourceColumnName, (Object)that.sourceColumnName) && com.google.common.base.Objects.equal((Object)this.destinationColumnName, (Object)that.destinationColumnName) && com.google.common.base.Objects.equal(this.function, that.function);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.sourceColumnName, this.destinationColumnName, this.function});
        }
    }
}

