/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class AnnotationObjectReplacer
implements Function<Object, Object> {
    private ConcurrentHashMap<Object, Object> objectCache = new ConcurrentHashMap();

    AnnotationObjectReplacer() {
    }

    @Override
    public Object apply(Object original) {
        Class<?> clazz = original.getClass();
        if (Annotation.class.isAssignableFrom(clazz) && Proxy.class.isAssignableFrom(clazz)) {
            return this.objectCache.computeIfAbsent(original, AnnotationObjectReplacer::replacementComputer);
        }
        return original;
    }

    private static Object replacementComputer(Object original) {
        Class<?>[] interfaces = original.getClass().getInterfaces();
        Class<?>[] extendedInterfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
        extendedInterfaces[extendedInterfaces.length - 1] = AnnotationSupport.constantAnnotationMarkerInterface;
        return Proxy.newProxyInstance(original.getClass().getClassLoader(), extendedInterfaces, Proxy.getInvocationHandler(original));
    }
}

